function c = bartlett (m)
  
  # usage:  bartlett (m)
  #
  # Returns the filter coefficients of a Bartlett (triangular) window
  # of length m. 
  #
  # For a definition of the Bartlett window, see e.g. A. V. Oppenheim
  # & R. W. Schafer, "Discrete-Time Signal Processing".

  # Written by AW (Andreas.Weingessel@ci.tuwien.ac.at) on Nov 9, 1994
  # Modified by AW on Jun 19, 1995
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin <> 1)
    error ("usage:  bartlett (m)");
  endif
  
  if !(is_scalar (m) && (m == round (m)) && (m > 0))
    error ("bartlett:  m has to be an integer > 0");
  endif
  
  if (m == 1)
    c = 1;
  else
    m = m - 1;
    n = fix (m / 2);
    c (1 : n+1) = 2 * (0 : n)' / m;
    c (n+2 : m+1) = 2 - 2 * (n+1 : m)'/m;
  endif

endfunction
