function c = blackman (m)
  
  # usage:  blackman (m)
  #
  # Returns the filter coefficients of a Blackman window of length m.
  #
  # For a definition of the  Blackman window, see e.g. A. V. Oppenheim &
  # R. W. Schafer, "Discrete-Time Signal Processing".

  # Written by AW (Andreas.Weingessel@ci.tuwien.ac.at) on Nov 9, 1994
  # Modified by AW on Jun 19, 1995
  # Copyright Dept of Probability Theory and Statistics TU Wien
  
  if (nargin <> 1)
    error ("usage:  blackman (m)");
  endif
  
  if !(is_scalar (m) && (m == round (m)) && (m > 0))
    error ("blackman:  m has to be an integer > 0");
  endif
  
  if (m == 1)
    c = 1;
  else
    m = m - 1;
    k = (0 : m)' / m;
    c = 0.42 - 0.5 * cos (2 * pi * k) + 0.08 * cos (4 * pi * k);
  endif
  
endfunction
