function cep = cceps (x, c)

  # usage:  cceps (x [, correct])
  #
  # Returns the complex cepstrum of the vector x.
  # If the optional argument correct has the value 1, a correction
  # method is applied.  The default is not to do this.

  # Written by AW (Andreas.Weingessel@ci.tuwien.ac.at) on Apr 1, 1994
  # Last modifified by AW on Nov 8, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien
  
  if (nargin == 1)
    c = 0;
  elseif (nargin != 2)
    error ("usage: cceps (x [, correct])");
  endif

  [nr, nc] = size (x);
  if (nc != 1)
    if (nr == 1)
      x = x';
      nr = nc;
    else
      error ("cceps: x must be a vector");
    endif
  endif

  bad_signal_message = ["cceps:  bad signal x, ", ...
      "some Fourier coefficients are zero."];
  
  F = fft (x);
  if (min (abs (F)) == 0)
    error (bad_signal_message);
  endif

  # determine if correction necessary
  half = fix (nr / 2);
  cor = 0;
  if (2 * half == nr)
    cor = (c && (real (F (half + 1)) < 0));
    if (cor)
      F = fft (x(1:nr-1))
      if (min (abs (F)) == 0)
	error (bad_signal_message);
      endif
    endif
  endif

  cep = fftshift (ifft (log (F)));

  # make result real
  if (c)
    cep = real (cep);
    if (cor)      
      # make cepstrum of same length as input vector
      cep (nr) = 0;
    endif
  endif

endfunction
