function y = cepstrum (x, t, c)

  # usage: retval = cepstrum (x [, type [, c]])
  #
  # Returns the cepstrum of the vector x.
  # If the value of `type' is "complex" or 1, the complex cepstrum is
  # computed; otherwise the real cepstrum is returned (default). 
  # The value of `c' determines whether the complex cepstrum is
  # corrected to be real-valued (c = 1) or not (c = 0, default).  If
  # the real cepstrum is computed, the value of c is not used.

  # Written by AW (Andreas.Weingessel@ci.tuwien.ac.at) on Apr 18, 1994
  # Last modified by AW on Nov 8, 1994
  # Copyright Department of Probability Theory and Statistics TU Wien

  if ((nargin == 0) || (nargin > 3))
    error ("usage:  cepstrum (x [, type [, c]])");
  endif

  if (nargin <= 2)
    c = 0;
    if (nargin == 1)
      t = 0;
    endif
  endif

  if isstr (t)
    if (strcmp (t, "complex"))
      t = 1;
    else      
      # use default value also for unknown arguments
      t = 0;
    endif
  endif

  if (t)
    y = cceps (x, c);
  else
    y = rceps (x);
  endif

endfunction
