function y = detrend (x, p)
  
  # usage:  detrend (x [, p])
  #
  # If x is a vector, detrend (x, p) removes the best fit of a
  # polynomial of order p from the data x.  
  # If x is a matrix, detrend (x, p) does the same for each column.
  #
  # If p is not specified, p = 1 is used, i.e., a linear trend is
  # removed.
  
  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on 94/10/11
  # Copyright Department of Statistics and Probability Theory TU Wien
  
  if (nargin == 1)
    p = 1;
  elseif (nargin == 2)
    if !( is_scalar (p) && (p == round (p)) && (p >= 0) )
      error ("detrend:  p must be a nonnegative integer");
    endif
  else
    error ("usage:  detrend (x [, p])");
  endif
  
  [m, n] = size (x);
  if (m == 1)
    x = x';
  endif
  
  r = rows (x);
  b = ((1 : r)' * ones (1, p + 1)) .^ (ones (r, 1) * (0 : p));
  y = x - b * (b \ x);
  
  if (m == 1)
    y = y';
  endif
  
endfunction