function Y = fftshift (X)
  
  # usage: Y = fftshift (X)
  #
  # If X is a vector, this function returns the vector with the left
  # and right halves swapped. If the length of X is odd, the middle
  # element is shifted to the right end.
  # If X is a matrix, this function returns a matrix where the 1st and
  # 3rd quadrants as well as the 2nd and 4th are swapped.

  # This is the Octave version of MATLAB's fftshift
  # Written by AW (Andreas.Weingessel@ci.tuwien.ac.at) on Sep 15, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin != 1) 
    error ('usage: fftshift (X)')
  endif

  [nr nc] = size (X);

  r1 = 1 : ceil (nr / 2);
  r2 = ceil (nr / 2) + 1 : nr;
  c1 = 1 : ceil (nc / 2);
  c2 = ceil (nc / 2) + 1 : nc;

  if (nr == 1)
    Y = [X(c2) X(c1)];
  elseif (nc == 1)
    Y = [X(r2); X(r1)];
  else
    Y = [X(r2, c2) X(r2, c1); X(r1, c2) X(r1, c1)];
  endif

endfunction
