function retval = fractdiff (x, d)
    
  # usage:  fractdiff(x, d)
  #
  # Computes the fractional differences (1-L)^d x where L denotes the
  # lag-operator and d > -1.
  
  # written by FL (Friedrich.Leisch@ci.tuwien.ac.at) on Aug 9, 1994
  # Updated by FL on Sep 6, 1994
  # Bug fix by FL on Sep 9, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien  
    
  N = 100;
  
  if !is_vector (x)
    error ("fractdiff:  x must be a vector")
  endif
  
  if !is_scalar (d)
    error ("fractdiff: d must be a scalar")
  endif
  
    
  if (d >= 1)
    for k = 1 : d
      x = x(2 : length (x)) - x(1 : length (x) - 1);
    endfor
  endif
  
  if (d > -1)
    
    d = rem (d, 1);
  
    if (d != 0)
      n = (0 : N)';
      w = real (gamma (-d+n) ./ gamma (-d) ./ gamma (n+1));
      retval = fftfilt (w, x);
      retval = retval(1 : length (x));
    else
      retval = x;
    endif
    
  else
    error ("fractdiff:  d must be > -1");
    
  endif
  
endfunction
