function c = hanning (m)
  
  # usage:  hanning (m)
  #
  # Returns the filter coefficients of a Hanning window of length m.
  #
  # For a definition of this window type, see e.g. A. V. Oppenheim &
  # R. W. Schafer, "Discrete-Time Signal Processing".
  
  # Written by AW (Andreas.Weingessel@ci.tuwien.ac.at) on Oct 14, 1994
  # Modified by AW on Jun 19, 1995
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin <> 1)
    error ("usage:  hanning (m)");
  endif
  
  if !(is_scalar (m) && (m == round (m)) && (m > 0))
    error ("hanning:  m has to be an integer > 0");
  endif
  
  if (m == 1)
    c = 1;
  else
    m = m - 1;
    c = 0.5 - 0.5 * cos (2 * pi * (0 : m)' / m);
  endif
  
endfunction
