function H = hurst (x)

  # usage:  H = hurst (x)
  #
  # Estimates the Hurst parameter of sample x via the rescaled range
  # statistic.  If x is a matrix, the parameter is estimated for every
  # single column.

  # Written by FL (Friedrich.Leisch@ci.tuwien.ac.at) on Aug 9, 1994
  # Copyright Department of Probability Theory and Statistics TU Wien  
  
  if (nargin <> 1)
    error ("usage:  hurst (x)");
  endif
  
  if is_vector (x)
    x = reshape (x, length (x), 1);
  elseif !is_matrix (x)
    error ("hurst:  x must be a vector or a matrix");
  endif
    
  [xr xc] = size (x);

  s = std (x);
  w = cumsum (x - mean (x));
  RS = (max(w) - min(w)) ./ s;
  H = log (RS) / log (xr);
  
endfunction




