function w = kaiser (n, beta)
  
  # usage:  kaiser (n, beta)
  # 
  # Returns the filter coefficients of the n-point Kaiser window with
  # parameter beta.
  # 
  # For the definition of the Kaiser window, see A. V. Oppenheim &
  # R. W. Schafer, "Discrete-Time Signal Processing".
  
  # Written by KH (Kurt.Hornik@tuwien.ac.at) on Jun 5, 1995
  # Copyright Dept of Probability Theory and Statistics TU Wien
  
  if (nargin <> 2)
    usage ("kaiser (n, beta)");
  endif
  
  if !(is_scalar (n) && (n == round (n)) && (n > 0))
    error ("kaiser:  n has to be a positive integer");
  endif
  if !(is_scalar (beta) && (beta == real (beta)))
    error ("kaiser:  beta has to be a real scalar");
  endif
  
  if (n == 1)
    w = 1;
  else
    m = n - 1;
    k = (0 : m)';
    k = 2 * beta / m * sqrt (k .* (m - k));
    w = besseli (0, k)/ besseli (0, beta);
  endif
    
endfunction