function retval = periodogram (x)

  # usage: periodogram (x)
  #
  # For a data matrix x from a sample of size n, return the
  # periodogram | fft (x - mean (x)) |.^2 / n.
  
  # Written by FL (Friedrich.Leisch@ci.tuwien.ac.at) on Oct 20, 1993
  # Copyright Departmentt of Probability Theory and Statistics TU Wien

  [r c] = size(x);

  if (r == 1)
    r = c;
  endif
  
  retval = (abs (fft (x - mean (x)))) .^ 2 / r;
  
endfunction

  





