function [Xhat, Y] = rceps (X)

  # usage:  [Xhat, Y] = rceps (X)
  #
  # Xhat = rceps (X) returns the real cepstrum of the vector X.
  # [Xhat, Y] = rcpes(X) returns the real cepstrum Xhat of X and a
  # minimum phase signal Y of the vector X. 

  # Written by AW (Andreas.Weingessel@ci.tuwien.ac.at) on Aprl 6, 1994
  # Last modified by AW on Nov 9, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien
  
  if (nargin != 1)
    error ("usage:  rceps (X)");
  endif

  [nr nc] = size (X);
  if (nc != 1)
    if (nr == 1)
      X = X';
      nr = nc;
    else
      error ("rceps:  X must be a vector");
    endif
  endif

  F = abs (fft (X));
  if (min (F) == 0)
    error ("rceps:  bad signal X, some Fourier coefficients are zero");
  endif
  Xhat = fftshift (ifft (log (F)));

  if (nargout > 1)
    nr = nr / 2;
    w = [1; 2 * ones (ceil (nr) - 1, 1); 1; zeros (floor (nr) - 1, 1)];
    Y = real (ifft (exp (fft (w .* Xhat))));
  endif

endfunction
