function y = rcepstrum (x)

  # usage:  rcepstrum (x)
  #
  # Returns the real cepstrum of the vector x.

  # Written by AW (Andreas.Weingessel@ci.tuwien.ac.at) on Apr 6, 1994
  # Last modified by AW on Nov 9, 1994
  # Copyright Department of Probability Theory and Statistics TU Wien
  
  if (nargin != 1)
    error ("usage: rcepstrum (x)");
  endif

  [nr nc] = size (x);
  if (nc != 1)
    if (nr == 1)
      x = x';
      nr = nc;
    else
      error ("rcepstrum:  x must be a vector.");
    endif
  endif

  F = abs (fft (x));
  if (min (F) == 0)
    error ("rcepstrum:  bad signal, some Fourier coefficients are zero.");
  endif

  y = fftshift (ifft (log (F)));

endfunction
