function retval = rectangle_sw (n, b)
  
  # usage: retval = rectangle_sw (n, b)
  #
  # Rectangular spectral window. Subfunction used for spectral density
  # estimation. 
  
  # Written by FL (Friedrich.Leisch@ci.tuwien.ac.at) on Dec 28, 1993
  # Copyright Department of Probability Theory and Statistics TU Wien

  retval = zeros (n, 1);
  retval(1) = 2 / b + 1;

  l = (2:n)' - 1;
  l = 2 * pi * l / n;

  retval(2:n) = sin( (2/b + 1) * l / 2 ) ./ sin (l / 2);
    
endfunction






























