function retval = sinetone (f, r, s, a)
  
  # usage : sinetone (freq [, rate [, sec [, ampl]]])
  #
  # Returns a sinetone of frequency freq with length of sec seconds at
  # sampling rate rate and with amplitude ampl.  freq and ampl may be 
  # vectors of common size.  
  # Defaults are rate = 8000, sec = 1 and ampl = 64.
    
  # Written by FL (Friedrich.Leisch@ci.tuwien.ac.at) on Nov 22, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien  
  
  if (nargin == 1)
    r = 8000;
    s = 1;
    a = 64;
  elseif (nargin == 2)
    s = 1;
    a = 64;
  elseif (nargin == 3)
    a = 64;
  elseif ((nargin < 1) || (nargin > 4))
    error ("usage:  sinetone (freq [, rate [, sec [, ampl]]])");
  endif
  
  [err, f, a] = common_size (f, a);
  if (err || is_matrix (f))
    error ("sinetone:  freq and ampl must be vectors of common size");
  endif
  
  if !(is_scalar (r) && is_scalar (s))
    error ("sinetone:  rate and sec must be scalars");
  endif

  n = length (f);

  retval = zeros (r * s, n);
  for k = 1:n
    retval (:, k) = a(k) * sin (2 * pi * (1:r*s) / r * f(k))';
  endfor
  
endfunction

