function x = sinewave (m, n, d)
  
  # usage:  sinewave (m, n [, d])
  #
  # Computes an (m x 1)-vector X with i-th element X(i) given by
  # sin (2 * pi * (i+d-1) / n). 
  # The default value for d is 0.

  # Written by AW (Andreas.Weingessel@ci.tuwien.ac.at) on Apr 5, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin == 2)
    d = 0;
  elseif (nargin != 3)
    error ("usage:  sinewave (m, n [, d])");
  endif

  x = sin ( ((1 : m) + d - 1) * 2 * pi / n);

endfunction
