function retval = spectral_adf (c, win, b)
  
  # usage: retval = spectral_adf (c, [win, [b]])
  # 
  # Returns the spectral density estimator.
  # c ....... vector of autocovariances (starting at lag 0)
  # win ..... window name, eg. "triangle" or "rectangle"
  #           spectral_adf searches for a function called win_lw ()
  # b ....... bandwidth
  # 
  # If win is omitted, the triangle window is used as default.
  # If b is omitted, 1 / sqrt( length (c)) is used as default.
  
  # Written by FL (Friedrich.Leisch@ci.tuwien.ac.at) on Dec 28, 1993
  # Copyright Department of Probability Theory and Statistics TU Wien
  
  cr = length (c);
  
  if (columns (c) > 1)
    c=c';
  endif

  if (nargin < 3)
    b = 1 / ceil (sqrt (cr));
  endif

  if (nargin == 1)
    w = triangle_lw (cr, b);
  else
    win = [win, "_lw"];
    w = feval (win, cr, b);
  endif
      
  c = c .* w;
  
  retval = 2 * real (fft (c)) - c(1);
  retval = [zeros (cr, 1) retval];
  retval(:, 1) = (0 : xr-1)' / xr;
  
endfunction
    

  


