function retval = spectral_xdf (X, win, b)
  
  # usage: retval = spectral_xdf (X, [win, [b]])
  # 
  # Returns the spectral density estimator.
  # X ....... data vector
  # win ..... window name, eg. "triangle" or "rectangle"
  #           spectral_adf searches for a function called win_sw ()
  # b ....... bandwidth
  # 
  # If win is omitted, the triangle window is used as default.
  # If b is omitted, 1 / sqrt (length (X)) is used as default.
  
  # Written by FL (Friedrich.Leisch@ci.tuwien.ac.at) on Dec 28, 1993
  # Copyright Departmentt of Probability Theory and Statistics TU Wien
  
  xr = length (X);
  
  if (columns (X) > 1)
    X = X';
  endif
  
  if (nargin < 3)
    b = 1 / ceil (sqrt (xr));
  endif
  
  if (nargin == 1)
    w = triangle_sw (xr, b);
  else
    win = [win, "_sw"];
    w = feval (win, xr, b);
  endif
  
  X = X - sum (X) / xr;

  retval = (abs (fft (X)) / xr).^2;
  retval = real (ifft (fft(retval) .* fft(w)));
  
  retval = [zeros (xr, 1) retval];
  retval(:, 1) = (0 : xr-1)' / xr;
  
endfunction
    

  





