function retval = spencer (X)
  
  # usage : spencer (X)
  #
  # returns Spencer's 15 point moving average of every single column
  # of X 
 
  # Written by FL (Friedrich.Leisch@ci.tuwien.ac.at) on Mar 23, 1993
  # Copyright Department of Probability Theory and Statistics TU Wien

  if (nargin <> 1)
    error("usage: spencer (X)");
  endif

  [xr xc] = size(X);
  
  n = xr;
  c = xc;
  
  if(is_vector(X))
   n = length(X);
   c = 1;
   X = reshape(X, n, 1);
  endif
   
  W = [ -3 -6 -5 3 21 46 67 74 67 46 21 3 -5 -6 -3 ] / 320;

  retval = fftfilt (W, X);
  retval = [zeros(7,c); retval(15:n,:); zeros(7,c);];
  
  retval = reshape(retval, xr, xc);
  
endfunction











