function retval = triangle_sw (n, b)
  
  # usage: retval = triangle_sw (n, b)
  #
  # Triangular spectral window.  Subfunction used for spectral density 
  # estimation. 
  
  # Written by FL (Friedrich.Leisch@ci.tuwien.ac.at) on Dec 28, 1993
  # Copyright Department of Probability Theory and Statistics TU Wien

  retval = zeros(n,1);
  retval(1) = 1 / b;

  l = (2:n)' - 1;
  l = 2 * pi * l / n;
  
  retval(2:n) = b * (sin (l / (2*b)) ./ sin (l / 2) ).^2;

endfunction






























