function [a, v] = yulewalker (c)
  
  # usage: [a, v] = yulewalker (c)
  # 
  # fits an AR (p)-model with Yule-Walker estimates.
  # c = [gamma_0, ..., gamma_p] autocovariances
  # a .... AR coefficients
  # v .... variance of white noise
  
  # Written by FL (Friedrich.Leisch@ci.tuwien.ac.at) on Dec 28, 1993
  # Copyright Department of Probability Theory and Statistics TU Wien
  
  p = length (c) - 1;
  
  if (columns (c) > 1)
    c = c';
  endif
  
  cp = c(2 : p+1);
  CP = zeros(p, p);
  
  for i = 1:p
    for j = 1:p
      CP(i, j) = c (abs (i-j) + 1);
    endfor
  endfor
  
  a = inv (CP) * cp;
  v = c(1) - a' * cp;
  
endfunction
    

  


