function close_fig(n)
#
# close_fig([n])
#
# close plot-window `n' or the current plot-window if n is nonexistent.
# Kill the gnuplot process, and makes the lowest plot-window the current one

#
# Modified by Joao Cardoso on Oct 20, 1995. jcardoso@bart.inescn.pt
#

global GNU_PIPE GNU_PIPE_CURRENT GNU_PIPE_FILE

if (nargin == 0)
	n = GNU_PIPE_CURRENT;
endif

if (exist("GNU_PIPE"))
	fd = GNU_PIPE(n);
	if (fd != 0)
		fprintf(fd,"quit\n");
		fflush(fd);
		fclose(fd);
		GNU_PIPE(n) = 0;
	endif

	if (n == GNU_PIPE_CURRENT)
		ix = find(GNU_PIPE != 0);
		if (isempty(ix))
			close_all_fig()
		else
			fig(ix(1))
		endif
	endif
endif

endfunction
