function f = fig(n)
#
# f = fig([n])
#
# Returns the identifier of window `n', creating it if not existent, and
# making it the current window. If `n' is non existent, reports the current
# plot-window.

#
# Modified by Joao Cardoso on Oct 20, 1995. jcardoso@bart.inescn.pt
#
global GNU_PIPE GNU_PIPE_CURRENT GNU_PIPE_FILE

if (! exist("GNU_PIPE"))
	GNU_PIPE = GNU_PIPE_FILE = [];
	fig(1);
endif

if (nargin == 0)
	f = GNU_PIPE_CURRENT;
	return
else
	if (n == rows(GNU_PIPE) + 1)
		tmp_file = tmp_file_name;
		GNU_PIPE_FILE = [GNU_PIPE_FILE tmp_file ' '];
		system(sprintf("mknod %s p", tmp_file));
		GNU_PIPE(n) = fopen(sprintf("%s",tmp_file),"w+");
		system(sprintf("%s < %s >/dev/tty &", gnuplot_binary, tmp_file));
	elseif ( n > rows(GNU_PIPE) + 1)
		error("Please create figures in sequence, or reuse closed figures\n")
	endif


	if (GNU_PIPE(n) == 0)
warning("Because of an Octave bug, it is not advisable to reuse closed figures");
		tmp_file = strntok(GNU_PIPE_FILE, '\n', n)
                system(sprintf("%s < %s >/dev/tty &", gnuplot_binary, tmp_file))
                GNU_PIPE(n) = fopen(sprintf("%s",tmp_file),"w+")
	endif
	
	f = GNU_PIPE_CURRENT = n;
        gnu_i(sprintf("set title ""Figure %d""",n));
endif

endfunction
