# Copyright (C) 1993, 1994, 1995 John W. Eaton
# 
# This file is part of Octave.
# 
# Octave is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any
# later version.
# 
# Octave is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Octave; see the file COPYING.  If not, write to the Free
# Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Modified by Joao Cardoso on Oct 20, 1995. jcardoso@bart.inescn.pt
#
function plot_2_v_m (x, y, fmt, name)

  if (nargin < 2 || nargin > 4)
    msg = sprintf ("plot_2_v_m (x, y)\n");
    msg = sprintf ("%s              plot_2_v_m (x, y, fmt)", msg);
    usage (msg);
  elseif (nargin == 2)
    fmt = "w l";
    name = "line";
  elseif (nargin == 3)
	if (isempty(fmt))
	  	fmt = "w l";
	endif
  	name = "line";
  endif

  [x_nr, x_nc] = size (x);
  [y_nr, y_nc] = size (y);

  if (x_nr == 1)
    x = x';
    tmp = x_nr;
    x_nr = x_nc;
    x_nc = tmp;
  endif

  if (x_nr == y_nr)
    1;
  elseif (x_nr == y_nc)
    y = y';
    tmp = y_nr;
    y_nr = y_nc;
    y_nc = tmp;
  else
    error ("plot_2_v_m: matrix dimensions must match");
  endif

  if (y_nc > 0)
    tmp = [x, y];

tmp_file = tmp_file_name;
tmp_1 = tmp(:,1:x_nc:x_nc+1);
eval(sprintf("save %s tmp_1", tmp_file));

global GNU_HOLD_CMD GNU_LINE_CNT

if (!exist("GNU_HOLD_CMD"))
	GNU_HOLD_CMD = ""; GNU_LINE_CNT=1;
endif

g_cmd = sprintf("""%s"" t ""%s %d"" %s", tmp_file, name, GNU_LINE_CNT++, fmt);
for i = 2:y_nc
	tmp_file = tmp_file_name;
	tmp_1 = tmp(:,1:i:i+1);
	eval(sprintf("save %s tmp_1", tmp_file));
	g_cmd = sprintf("%s, ""%s"" t ""%s %d"" %s", g_cmd, tmp_file, name, GNU_LINE_CNT++, fmt);
endfor

if (!ishold)		# normal mode
	GNU_HOLD_CMD = g_cmd;
	gnu_i( sprintf("plot %s",GNU_HOLD_CMD));
	GNU_LINE_CNT = 1;
	return
else		
	GNU_HOLD_CMD = sprintf("%s, %s", GNU_HOLD_CMD, g_cmd);
	gnu_i( sprintf("plot %s",GNU_HOLD_CMD));
	return
endif

  else
    error ("plot_2_v_m: arguments must be a matrices");
  endif

endfunction
