# Copyright (C) 1993, 1994, 1995 John W. Eaton
# 
# This file is part of Octave.
# 
# Octave is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any
# later version.
# 
# Octave is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Octave; see the file COPYING.  If not, write to the Free
# Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Modified by Joao Cardoso on Oct 20, 1995. jcardoso@bart.inescn.pt
#
function semilogy (...)

# usage: semilogy (x, y)
#        semilogy (x1, y1, x2, y2, ...)
#        semilogy (x, y, fmt)
#
# Make a 2D plot of y versus x using a log scale for the x axis. 
#
# See the help message for the plot command for a description of how
# the arguments are interpreted. 
#
# See also: plot, semilogx, loglog, polar, mesh, contour, bar, stairs,
#           gplot, gsplot, replot, xlabel, ylabel, title 

  gnu_i("set nologscale x; set logscale y; set nopolar;")

  plot_int ("semilogy", all_va_args);

endfunction
