function tok = strntok(s1, s2, n)
#
# token = strtok(string, separator, item)
#
# returns the n-th token in string, tokens separated by character separator

# Modified by Joao Cardoso on Oct 20, 1995. jcardoso@bart.inescn.pt
#
a = find(s1 == s2);

if ((columns(a) == 1 && n != 1) || (columns(a) < n))
	tok = [];
	return
endif

p2 = a(n)-1;
if (n == 1)
	p1 = 1;		# assume separator is at end
else
	p1 = a(n-1)+1;
endif

b = toascii(s1);
tok = setstr(b(p1:p2));

endfunction

