function k = commutation_matrix (m, n)
  
  # usage:  commutation_matrix (m [, n])
  # 
  # Returns the commutation matrix K_{m,n} which is the unique m*n by
  # m*n matrix such that K_{m,n} * vec (A) = vec (A') for all m by n
  # matrices A.
  # If only one argument m is given, K_{m,m} is returned.
  #
  # See Magnus & Neudecker (1988), Matrix differential calculus with
  # applications in statistics and econometrics.

  # Written by KH (Kurt.Hornik@tuwien.ac.at) on 1995/05/08
  # Copyright Dept of Probability Theory and Statistics TU Wien
  
  if ((nargin < 1) || (nargin > 2))
    usage ("commutation_matrix (m [, n])");
  else
    if !(is_scalar (m) && (m == round (m)) && (m > 0))
      error ("commutation_matrix:  m must be a positive integer");
    endif
    if (nargin == 1)
      n = m;
    elseif !(is_scalar (n) && (n == round (n)) && (n > 0))
      error ("commutation_matrix:  n must be a positive integer");
    endif
  endif
  
  # It is clearly possible to make this a LOT faster!
  k = zeros (m * n, m * n);
  for i = 1 : m
    for j = 1 : n
      k ((i - 1) * n + j, (j - 1) * m + i) = 1;
    endfor
  endfor
  
endfunction