function z = cross (x, y)
  
  # usage:  cross (x, y)
  #
  # Computes the vector cross product of the two 3-dimensional vectors
  # x and y.
  
  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on 1994/10/15
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin != 2)
    usage ("cross (x, y)");
  endif

  if !( (is_vector (x)) && (length (x) == 3) ...
      && (is_vector (y)) && (length (y) == 3) )
    error ("cross:  both x and y must be 3-dimensional vectors");
  endif
  
  x = reshape (x, 3, 1);
  y = reshape (y, 3, 1);
  e = eye (3, 3);
  for k = 1 : 3
    z(k) = det ([x y e(:, k)]);
  endfor
  
endfunction

  