function M = dmult (a, B)
  
  # usage:  dmult (a, B)
  # 
  # If a is a vector of length rows (B), return diag (a) * B (but
  # computed much more efficiently).
  
  # Written by KH <Kurt.Hornik@tuwien.ac.at> on June 18, 1995
  # Copyright Dept of Statistics and Probability Theory, TU Wien
  
  if (nargin <> 2)
    usage ("dmult (a, B)");
  endif
  
  s = size (a);
  if ((min (s) > 1) || (max (s) <> rows (B)))
    error ("dmult:  a must be a vector of length rows (B)");
  endif
  
  M = (reshape (a, max (s), 1) * ones (1, columns (B))) .* B;
  
endfunction
