function d = duplication_matrix (n)
  
  # usage:  duplication_matrix (n)
  # 
  # Returns the duplication matrix D_n which is the unique n^2 by
  # n*(n+1)/2 matrix such that D_n * vech (A) = vec (A) for all
  # symmetric n by n matrices A.
  # 
  # See Magnus & Neudecker (1988), Matrix differential calculus with
  # applications in statistics and econometrics.
  
  # Written by KH (Kurt.Hornik@tuwien.ac.at) on 1995/05/08
  # Copyright Dept of Probability Theory and Statistics TU Wien
  
  if (nargin <> 1)
    usage ("duplication_matrix (n)");
  endif
  
  if !(is_scalar (n) && (n == round (n)) && (n > 0))
    error ("duplication_matrix:  n must be a positive integer");
  endif
  
  d = zeros (n * n, n * (n + 1) / 2);
  
  # It is clearly possible to make this a LOT faster!
  count = 0;
  for j = 1 : n
    d ((j - 1) * n + j, count + j) = 1;
    for i = (j + 1) : n
      d ((j - 1) * n + i, count + i) = 1;
      d ((i - 1) * n + j, count + i) = 1;
    endfor
    count = count + n - j;
  endfor
  
endfunction