function v = vec (x)
  
  # usage:  vec (x)
  #
  # Returns vec (x), the vector obtained by stacking the columns of x
  # one above the other.
  # 
  # See Magnus & Neudecker (1988), Matrix differential calculus with
  # applications in statistics and econometrics.

  # Written by KH (Kurt.Hornik@tuwien.ac.at) on 1995/05/08
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin != 1)
    usage ("vec (x)"); 
  endif 
  
  v = reshape (x, prod (size (x)), 1);
  
endfunction

  
