function v = vech (x)
  
  # For square x, returns the vector vech (x) which is obtained from x
  # by eliminating all supradiagonal elements and stacking the result
  # one column above the other.
  # 
  # See Magnus & Neudecker (1988), Matrix differential calculus with
  # applications in statistics and econometrics.

  # Written by KH (Kurt.Hornik@tuwien.ac.at) on 1995/05/08
  # Copyright Dept of Probability Theory and Statistics TU Wien
  
  if (nargin <> 1)
    usage ("vech (x)");
  endif
  
  if !is_square (x)
    error ("vech:  x must be square");
  endif
  
  # This should be quicker than having an inner `for' loop as well.
  # Ideally, vech should be written in C++.
  n = rows (x);
  count = 0;
  for j = 1 : n
    i = j : n; 
    v (count + i) = x (i, j);
    count = count + n - j;
  endfor
  
endfunction
