#include <stdio.h>

char buffer0[1024], buffer1[1024], prefix[6];

struct htab {
	char *h_key;
	char *h_val;
} *htab;
int htabsiz, htabnent;

main(argc, argv)
int argc;
char **argv;
{
	register count, i;
	char *k, *v;
	extern char *malloc();

	if (argc < 2) {
		printf("Arg count.\n");
		exit(1);
	}
	htabsiz = atoi(argv[1]);
	htab = (struct htab *)malloc(sizeof(struct htab) * htabsiz);
	for (i = 0;  i < htabsiz;  i++)
		htab[i].h_key = NULL;

START:
	readline(buffer0);
L:
	readline(buffer1);
	if (strncmp(buffer0, buffer1, 7) != 0) {
		strcpy(buffer0, buffer1);
		goto L;
	}
	if (strncmp(prefix, buffer0, 5) != 0) {
		count = 0;
		strncpy(prefix, buffer0, 5);
	}
	if (argc >= 3) {
		printf("%s\n", buffer1);
		fflush(stdout);
	}
	k = malloc(strlen(buffer0) + 1);
	v = malloc(strlen(buffer0) + 3);
	strcpy(k, buffer0);
	if (++count >= 10*26) {
		fprintf(stderr, "Too many similar identifiers.\n");
		exit(1);
	}
	sprintf(v, "%s%c%c%s",
		prefix, '0'+count%10, 'A'+count/10, buffer0+5);
	enter(k, v);
LL:
	if (argc >= 3) {
		printf("%s\n", buffer1);
		fflush(stdout);
	}
	k = malloc(strlen(buffer1) + 1);
	v = malloc(strlen(buffer1) + 3);
	strcpy(k, buffer1);
	if (++count >= 10*26) {
		fprintf(stderr, "Too many similar identifiers.\n");
		exit(1);
	}
	sprintf(v, "%s%c%c%s",
		prefix, '0'+count%10, 'A'+count/10, buffer1+5);
	enter(k, v);
	readline(buffer1);
	if (strncmp(buffer0, buffer1, 7) != 0) {
		strcpy(buffer0, buffer1);
		goto L;
	}
	goto LL;
}

readline(s)
char *s;
{
	register i, c;

	c = getchar();
	if (feof(stdin))
		output();
	for (i = 0;  c != '\n';  i++, c = getchar())
		s[i] = c;
	s[i] = '\0';
}

#include "hash.c"

enter(k, v)
char *k, *v;
{
	int s;

	if (htabnent++ > htabsiz/2) {
		fprintf(stderr, "Htab overflow.\n");
		exit(1);
	}
	s = hash(k, htabsiz);
	while (htab[s].h_key != NULL)
		s = (s+1)%htabsiz;
	htab[s].h_key = k;
	htab[s].h_val = v;
}

output()
{
	register i;

	i = 0;
	printf("/*  %d entries  */\n", htabnent);
	printf("struct htab {\n\tchar *h_key;\n\tchar *h_val;\n} htab[%d] = {\n", htabsiz);
	for (i = 0;  i < htabsiz;  i++)
		if (htab[i].h_key != NULL)
			printf("\t{\"%s\", \"%s\"},\n", htab[i].h_key, htab[i].h_val);
		else
			printf("\t{0, 0},\n");
	printf("};\n");
	exit(0);
}
