/*
OS/2 - emx version of the fast loader.  This is based on the Unix (BSD)
version.  The difference is the new total size of text, data and bss
is checked rather than just the new bss size.
Sentot Kromodimoeljo, October 1993.
*/

/*
(c) Copyright Taiichi Yuasa and Masami Hagiya, 1984.  All rights reserved.
Copying of this file is authorized to users who have executed the true and
proper "License Agreement for Kyoto Common LISP" with SIGLISP.
*/

#include "include.h"


#include <a_out.h>

#define	MAXPATHLEN	1024
#define	textsize	header.a_text
#define	datasize	header.a_data
#define	bsssize		header.a_bss
#define	textstart	sizeof(header)
#define newtextsize     newheader.a_text
#define newdatasize     newheader.a_data
#define	newbsssize	newheader.a_bss

int
fasload(faslfile)
object faslfile;
{
	struct exec header, newheader;
	char *cp, *getenv();
	object memory, data, tempfile;
	FILE *fp;
	char filename[MAXPATHLEN];
	char tempfilename[32];
	char command[MAXPATHLEN * 2];
	int i;
	object *old_vs_base = vs_base;
	object *old_vs_top = vs_top;

	coerce_to_filename(faslfile, filename);

	faslfile = open_stream(faslfile, smm_input, Cnil, Kerror);
	vs_push(faslfile);
	fp = faslfile->sm.sm_fp;
	fread(&header, sizeof(header), 1, fp);
	memory = alloc_object(t_cfun);
	memory->cf.cf_name = memory->cf.cf_data = OBJNULL;
	memory->cf.cf_start = NULL;
	memory->cf.cf_size = textsize + datasize + bsssize;
	vs_push(memory);
	memory->cf.cf_start = alloc_contblock(memory->cf.cf_size);
	fseek(fp,
	      header.a_text+header.a_data+
	      header.a_syms+header.a_trsize+header.a_drsize,
	      1);
	fread(&i, sizeof(i), 1, fp);
	fseek(fp, i - sizeof(i), 1);
	data = read_fasl_vector(faslfile);
	vs_push(data);
	close_stream(faslfile, TRUE);

	if ((cp = getenv ("TEMP")) == NULL &&
	    (cp = getenv ("TMP")) == NULL)
	  strcpy (tempfilename, "/tmp/fasltemp");
	else
	  sprintf(tempfilename, "%s/fasltemp", cp);

AGAIN:
	sprintf(command,
		"ld -d -N -x -A %s -T %x %s -o %s",
		kcl_self,
		memory->cf.cf_start,
		filename,
		tempfilename);

	if (system(command) != 0)
		FEerror("The linkage editor failed.", 0);

	tempfile = make_simple_string(tempfilename);
	vs_push(tempfile);
	tempfile = open_stream(tempfile, smm_input, Cnil, Kerror);
	vs_push(tempfile);
	fp = tempfile->sm.sm_fp;
	fread(&newheader, sizeof(header), 1, fp);
	if ((newtextsize + newdatasize + newbsssize) !=
	    (textsize + datasize + bsssize)) {
		insert_contblock(memory->cf.cf_start, memory->cf.cf_size);
		textsize = newtextsize;
		datasize = newdatasize;
		bsssize = newbsssize;
		memory->cf.cf_start = NULL;
		memory->cf.cf_size = textsize + datasize + bsssize;
		memory->cf.cf_start = alloc_contblock(memory->cf.cf_size);
		close_stream(tempfile, TRUE);
		unlink(tempfilename);
		goto AGAIN;
	}

	if (fseek(fp, textstart, 0) < 0)
		error("file seek error");

	fread(memory->cf.cf_start, textsize + datasize, 1, fp);
	close_stream(tempfile, TRUE);
	unlink(tempfilename);

	(*(int (*)())(memory->cf.cf_start))
		(memory->cf.cf_start, memory->cf.cf_size, data);

	vs_base = old_vs_base;
	vs_top = old_vs_top;
/*
	GBC(t_contiguous);
*/

	return(memory->cf.cf_size);
}


int
faslink(faslfile, ldargstring)
object faslfile, ldargstring;
{
	struct exec header, faslheader;
	object memory, data, tempfile;
	FILE *fp;
	char filename[MAXPATHLEN];
	char ldargstr[MAXPATHLEN];
	char tempfilename[32];
	char command[MAXPATHLEN * 2];
	char buf[BUFSIZ];
	int i;
	object *old_vs_base = vs_base;
	object *old_vs_top = vs_top;
	char *cp, *getenv();

	coerce_to_filename(ldargstring, ldargstr);
	coerce_to_filename(faslfile, filename);

	if ((cp = getenv ("TEMP")) == NULL &&
	    (cp = getenv ("TMP")) == NULL)
	  strcpy (tempfilename, "/tmp/fasltemp");
	else
	  sprintf(tempfilename, "%s/fasltemp", cp);

	sprintf(command,
		"ld -d -N -x -A %s -T %x %s %s -o %s",
		kcl_self,
		(int)core_end,
		filename,
		ldargstr,
		tempfilename);

	if (system(command) != 0)
		FEerror("The linkage editor failed.", 0);

	fp = fopen(tempfilename, "rb");
	fp->buffer = NULL;
	setbuf(fp, buf);
	fread(&header, sizeof(header), 1, fp);
	memory = alloc_object(t_cfun);
	memory->cf.cf_name = memory->cf.cf_data = OBJNULL;
	memory->cf.cf_start = NULL;
	memory->cf.cf_size = textsize + datasize + bsssize;
	vs_push(memory);
	memory->cf.cf_start = alloc_contblock(memory->cf.cf_size);
	fp->buffer = NULL;
	fclose(fp);

	faslfile = open_stream(faslfile, smm_input, Cnil, Kerror);
	vs_push(faslfile);
	fp = faslfile->sm.sm_fp;
	fread(&faslheader, sizeof(faslheader), 1, fp);
	fseek(fp,
	      faslheader.a_text+faslheader.a_data+
	      faslheader.a_syms+faslheader.a_trsize+faslheader.a_drsize,
	      1);
	fread(&i, sizeof(i), 1, fp);
	fseek(fp, i - sizeof(i), 1);

	data = read_fasl_vector(faslfile);
	vs_push(data);
	close_stream(faslfile, TRUE);

	sprintf(command,
		"ld -d -N -x -A %s -T %x %s %s -o %s",
		kcl_self,
		memory->cf.cf_start,
		filename,
		ldargstr,
		tempfilename);

	if (system(command) != 0)
		FEerror("The linkage editor failed.", 0);

	tempfile = make_simple_string(tempfilename);
	vs_push(tempfile);
	tempfile = open_stream(tempfile, smm_input, Cnil, Kerror);
	vs_push(tempfile);
	fp = tempfile->sm.sm_fp;

	if (fseek(fp, textstart, 0) < 0)
		error("file seek error");

	fread(memory->cf.cf_start, textsize + datasize, 1, fp);

	close_stream(tempfile, TRUE);
	unlink(tempfilename);

	(*(int (*)())(memory->cf.cf_start))
		(memory->cf.cf_start, memory->cf.cf_size, data);

	vs_base = old_vs_base;
	vs_top = old_vs_top;

	return(memory->cf.cf_size);
}

siLfaslink()
{
	bds_ptr old_bds_top;
	int i;
	object package;

	check_arg(2);
	check_type_or_pathname_string_symbol_stream(&vs_base[0]);
	check_type_string(&vs_base[1]);
	vs_base[0] = coerce_to_pathname(vs_base[0]);
	vs_base[0]->pn.pn_type = FASL_string;
	vs_base[0] = namestring(vs_base[0]);
	package = symbol_value(Vpackage);
	old_bds_top = bds_top;
	bds_bind(Vpackage, package);
	i = faslink(vs_base[0], vs_base[1]);
	bds_unwind(old_bds_top);
	vs_top = vs_base;
	vs_push(make_fixnum(i));
}


init_unixfasl()
{
	make_si_function("FASLINK", siLfaslink);
}
