/* PMTclSh for OS/2 ver 1.0 -- tcl shell for OS/2
 * Copyright (C) 1996 Fornari Stefano
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose is granted without fee, provided that the above copyright notice
 * and the following paragraph appear in all copies of this software
 * and supporting documentation.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  In no event shall the author be
 * liable to any party for direct, indirect, special, incidental, or
 * consequential damages arising out of the use of this software and its
 * documentation.
 */

/*-----------------------------------------------------
   thInterp -- tcl 7.4 Interpreter for OS/2
  -----------------------------------------------------*/
  
#define INCL_DOSSEMAPHORES
#define INCL_DOSPROCESS
#define INCL_DOSQUEUES
#define INCL_WINMLE

#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <os2.h>

#include "tcl.h"
#include "pmtclsh.h"



static TID        tidInterp, tidOutput;
static PID        pidInterp;

void ThreadWriteOutErr(PVOID pParam)
{
    PTHREADPARAM pthParam = (PTHREADPARAM)pParam;
    LONG         nLen, nCar;
    CHAR         buf[DIMBUF];
    HMQ          hmq;
  
    hmq = WinCreateMsgQueue(WinInitialize(0), 0);

    DosPostEventSem(pthParam->hSem);
        
    while (1)
    {
        if ((nCar = read(pthParam->hPipe, buf, sizeof(buf)-1)) < 0)
        {
            WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, strerror(errno), "Error!", 0, MB_OK|MB_ERROR);
            return;
        }
        buf[nCar] = '\0';
        
        nLen = (LONG)WinSendMsg(pthParam->hwnd, MLM_QUERYTEXTLENGTH, 0, 0);
      
        WinSendMsg(pthParam->hwnd, MLM_SETSEL, (MPARAM)nLen, (MPARAM)nLen);
        WinSendMsg(pthParam->hwnd, MLM_INSERT, (MPARAM)buf, 0);
    }
}


BOOL CreateInterp(HWND hwndOutput, HFILE hPipe)
{
    char               st[100], cmd[] = "tclsh.exe\0\0";
    ULONG              ul;
    RESULTCODES        rc;
    static THREADPARAM thParam;

    
    if (DosCreateEventSem(NULL, &thParam.hSem, 0, 0)) return FALSE;
   
    DosExecPgm(st, sizeof(st)-1, EXEC_ASYNC, cmd, NULL, (PRESULTCODES)&pidInterp, cmd);
    
    thParam.hwnd = hwndOutput;
    thParam.hPipe = hPipe;
    if ((tidOutput = _beginthread(ThreadWriteOutErr, NULL, 8192, &thParam)) == -1)
    {
        DosKillProcess(0, pidInterp);
        return FALSE;
    }
        
    DosCloseEventSem(thParam.hSem);

    return TRUE;
}


void DestroyInterp(void)
{
    DosKillProcess(0, pidInterp);
    DosKillThread(tidInterp); DosKillThread(tidOutput);
}
