/*  */

Call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
Call SysLoadFuncs

parse arg action

if action = '+' then nop
else if action = '-' then nop
else do
  say 'Usage: FATFS +|-'
  exit
end

parse source . . home
home = left(home,lastpos('\',home)-1)      /* Strip "\<cmd-name>" */
home = left(home,lastpos('\',home)-1)      /* Strip "\BIN" */

ext = 'def'
call Rename
ext = 'odf'
call Rename

call Toggle
exit

Toggle:
  cfg = home'\bin\xc.cfg'
  rc = stream(cfg,'c','open read')
  if rc <> 'READY:' then do
    say 'Error opening 'name': 'rc
    exit
  end
  
  fatfs = action'fatfs % Do not toggle this option! Instead, use the FATFS.CMD script'
  
  newcfg = SysTempFileName(home'\bin\xc.???')
  rc = stream(newcfg,'c','open write')
  
  do while lines(cfg) <> 0
    line = linein(cfg)
    newline = space(line,0)||' '
    if (substr(newline,2,5) = 'fatfs') & ,
       (pos(left(newline,1),'+-') > 0) & ,
       (pos(substr(newline,7,1),'+-% ') > 0) then do
       line = fatfs
       fatfs = ''
    end
    call lineout newcfg, line
  end
  
  if fatfs <> '' then
    call lineout newcfg, fatfs
  
  rc = stream(cfg,'c','close')
  rc = stream(newcfg,'c','close')
  
  '@del 'cfg
  '@ren 'newcfg' xc.cfg'

  return

Rename:
  call SysFileTree home'\*.'ext, file, 's'
  do i = 1 to file.0
    parse var file.i date time size attrib name
    name = strip(name)
    if pos('SAMPLES',name) <> 0 then iterate
  
    call LocateModuleId
    if module = '' then do
      say 'Failed to locate module id in' name
      exit
    end
    old = substr(name,lastpos('\',name)+1)
    old = substr(old,1,lastpos('.',old)-1)
  
    select
    when action = '-' then do
      new = module
      if translate(old) <> translate(strip(substr(module,1,8))) then do
        say 'Name inconsistency: ' old module
        exit
      end
    end
    when action = '+' then do
      new = strip(substr(module,1,8))
      if translate(old) <> translate(module) then do
        say 'Name inconsistency: ' old module
        exit
      end
    end
    otherwise iterate
    end
  
    say old '->' new
    '@ren' name new'.'ext
    sym = home'\SYM\'old'.sym'
    if stream(sym,'c','query exists') <> '' then
      '@ren' sym new'.sym'
  
  end
  return

LocateModuleId:
  rc = stream(name,'c','open read')
  if rc <> 'READY:' then do
    say 'Error opening 'name': 'rc
    exit
  end
  module = ''
  do while lines(name) <> 0
    line = linein(name)
    if word(line,1) = 'DEFINITION' then do
      module = word(line,2)
      if module = 'MODULE' then do
        module = word(line,3)
        if substr(module,1,1) = '[' then module = word(line,4)
      end
      module = strip(translate(module,,';'))
      leave
    end
  end
  rc = stream(name,'c','close')
  return
