/*
 * Copyright (c) 1987, 1988, 1989, 1990, 1991 Stanford University
 * Copyright (c) 1991 Silicon Graphics, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Stanford and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Stanford and Silicon Graphics.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL STANFORD OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 */

/*
 * StringEditor - interactive editor for character strings
 */

#include <InterViews/bitmap.h>
#include <InterViews/cursor.h>
#include <InterViews/font.h>
#include <InterViews/window.h>
#include <IV-2_6/InterViews/button.h>
#include <IV-2_6/InterViews/painter.h>
#include <IV-2_6/InterViews/sensor.h>
#include <IV-2_6/InterViews/shape.h>
#include <IV-2_6/InterViews/stredito.h>
#include <IV-2_6/InterViews/textbuff.h>
#include <IV-2_6/InterViews/textdisp.h>
#include <IV-2_6/InterViews/world.h>
#include <IV-X11/xcanvas.h>
#include <IV-X11/xevent.h>
#include <IV-X11/xwindow.h>
#include <OS/math.h>
#include <ctype.h>
#include <stdio.h>
#include <string.h>


static const int BUFFERSIZE = 1000;

StringEditor::StringEditor (
    ButtonState* s, const char* samp, const char* done
) {
    Init(s, samp, done);
}

StringEditor::StringEditor (
    const char* name, ButtonState* s, const char* samp, const char* done
) {
    SetInstance(name);
    Init(s, samp, done);
}

void StringEditor::Init (ButtonState* s, const char* samp, const char* d) {
    SetClassName("StringEditor");
    sample = strcpy(new char[strlen(samp) + 1], samp);
    size = BUFFERSIZE;
    buffer = new char[size];
    text = new TextBuffer(buffer, 0, size);
    left = 0;
    right = 0;
    subject = s;

    if (subject != nil) {
        subject->Attach(this);
    }
    done = strcpy(new char[strlen(d) + 1], d);
    display = new TextDisplay();
    Message(sample);
}

StringEditor::~StringEditor () {
    if (subject != nil) {
        subject->Detach(this);
    }
    delete text;
    delete sample;
    delete done;
    delete buffer;
    delete display;
}

void StringEditor::Reconfig ()
{
    const Font* f = output->GetFont();
    shape->Rect(f->Width(sample), f->Height());
    shape->Rigid(hfil, hfil, 0, 0);
    display->LineHeight(f->Height());
}

void StringEditor::Resize () {
    display->Draw(output, canvas);
    display->Resize(0, 0, xmax, ymax);
    Select(left, right);
}


void StringEditor::Redraw (IntCoord l, IntCoord b, IntCoord r, IntCoord t)
{
    RECTL   rt;

    rt.xLeft = l; rt.yBottom = b; rt.xRight = r; rt.yTop = t;
    WinInvalidateRect(GetCanvas()->window()->rep()->xwindow_, &rt, FALSE);
}

void StringEditor::Message (const char* t)
{
    WinSetWindowText(GetCanvas()->window()->rep()->xwindow_, (PSZ)t);
}


void StringEditor::Select (int l)
{
}


void StringEditor::Select (int l, int r)
{
}


void StringEditor::DoSelect (int l, int r)
{
}

void StringEditor::Edit () {
    Event e;
    e.target = nil;
    e.eventType = EnterEvent;
    Handle(e);
}

void StringEditor::Edit (const char* t, int l, int r) {
    Message(t);
    Select(l, r);
    Edit();
}

const char* StringEditor::Text ()
{
    WinQueryWindowText(
        GetCanvas()->window()->rep()->xwindow_, BUFFERSIZE, (PSZ) text->Text()
    );
    return text->Text();
}

boolean StringEditor::HandleChar (char c)
{
}

void StringEditor::InsertText (const char* t, int len) {
}


void StringEditor::Handle (Event& e)
{
    e.rep()->processed_ = false;
}
