# Local additions to Autoconf 2.12 macros.
#
#
# Copyright (C) 1997 Markus Franz Xaver Johannes Oberhumer
# Copyright (C) 1996 Markus Franz Xaver Johannes Oberhumer
#

## --------------------------------------------------------- ##
## Includes <stdlib.h> and <stddef.h> if available.          ##
## Adapted from AC_CHECK_SIZEOF (Autoconf 2.12).             ##
## --------------------------------------------------------- ##

dnl mfx_CHECK_SIZEOF(TYPE [, CROSS-SIZE])
AC_DEFUN(mfx_CHECK_SIZEOF,
[changequote(<<, >>)dnl
dnl The name to #define.
define(<<AC_TYPE_NAME>>, translit(sizeof_$1, [a-z *], [A-Z_P]))dnl
dnl The cache variable name.
define(<<AC_CV_NAME>>, translit(ac_cv_sizeof_$1, [ *], [_p]))dnl
changequote([, ])dnl
AC_MSG_CHECKING(size of $1)
AC_CACHE_VAL(AC_CV_NAME,
[AC_TRY_RUN([#include <stdio.h>
#if STDC_HEADERS
#include <stdlib.h>
#include <stddef.h>
#endif
main()
{
  FILE *f=fopen("conftestval", "w");
  if (!f) exit(1);
  fprintf(f, "%d\n", sizeof($1));
  exit(0);
}], AC_CV_NAME=`cat conftestval`, AC_CV_NAME=0, ifelse([$2], , , AC_CV_NAME=$2))])dnl
AC_MSG_RESULT($AC_CV_NAME)
AC_DEFINE_UNQUOTED(AC_TYPE_NAME, $AC_CV_NAME)
undefine([AC_TYPE_NAME])dnl
undefine([AC_CV_NAME])dnl
])


## --------------------------------------------------------- ##
## Check if gcc accepts '-pipe'.                             ##
## Adapted from AC_PROG_CC and AC_PROG_GCC_TRADITIONAL.      ##
## --------------------------------------------------------- ##

AC_DEFUN(mfx_PROG_GCC_PIPE,
[AC_REQUIRE([AC_PROG_CC])dnl
AC_REQUIRE([AC_PROG_CPP])dnl
if test $ac_cv_prog_gcc = yes; then
AC_CACHE_CHECK(whether ${CC-cc} accepts -pipe, mfx_cv_prog_gcc_pipe,
[echo 'main() { return 0; }' > conftest.c
if test -z "`${CC-cc} -pipe -c conftest.c 2>&1`"; then
  mfx_cv_prog_gcc_pipe=yes
else
  mfx_cv_prog_gcc_pipe=no
fi
rm -f conftest*
])
  if test $mfx_cv_prog_gcc_pipe = yes; then
    CC="$CC -pipe"
  fi
fi
])


## --------------------------------------------------------- ##
## Check if gcc suffers the '-fstrength-reduce' bug.         ##
## --------------------------------------------------------- ##

AC_DEFUN(mfx_PROG_GCC_BUG_STRENGTH_REDUCE,
[AC_REQUIRE([AC_PROG_CC])dnl
AC_REQUIRE([AC_PROG_CPP])dnl
if test $ac_cv_prog_gcc = yes; then
mfx_save_cflags=$CFLAGS
CFLAGS="$CFLAGS -O2 -fstrength-reduce"
AC_CACHE_CHECK(whether ${CC-cc} suffers the -fstrength-reduce bug,
mfx_cv_prog_gcc_bug_strength_reduce,
[AC_TRY_RUN([
/* gcc strength-reduce optimization bug on Intel platforms.
 * Adapted from bug-report by John E. Davis <davis@space.mit.edu>
 * Compile and run it using gcc -O2 -fno-strength-reduce and
 * gcc -O2 -fstrength-reduce.
 */
int a[3];
unsigned an = 3;
int strength_reduce_bug();
main()
{
  unsigned j;
  for (j = 0; j < an; j++)
    a[j] = (int)j - 3;
  exit(strength_reduce_bug() ? 1 : 0);
}
int strength_reduce_bug()
{
  return a[0] != -3 || a[1] != -2 || a[2] != -1;
}], mfx_cv_prog_gcc_bug_strength_reduce=no, mfx_cv_prog_gcc_bug_strength_reduce=yes)])
CFLAGS=$mfx_save_cflags
fi
MFX_PROG_GCC_BUG_STRENGTH_REDUCE=$mfx_cv_prog_gcc_bug_strength_reduce
AC_SUBST(MFX_PROG_GCC_BUG_STRENGTH_REDUCE)dnl
])


## --------------------------------------------------------- ##
## Check if gcc suffers the '-fschedule-insns' bug.          ##
## --------------------------------------------------------- ##

AC_DEFUN(mfx_PROG_GCC_BUG_SCHEDULE_INSNS,
[AC_REQUIRE([AC_PROG_CC])dnl
AC_REQUIRE([AC_PROG_CPP])dnl
if test $ac_cv_prog_gcc = yes; then
mfx_save_cflags=$CFLAGS
CFLAGS="$CFLAGS -O2 -fschedule-insns -fschedule-insns2"
AC_CACHE_CHECK(whether ${CC-cc} suffers the -fschedule-insns bug,
mfx_cv_prog_gcc_bug_schedule_insns,
[AC_TRY_RUN([
/* gcc schedule-insns optimization bug on RS6000 platforms.
 * Adapted from bug-report by Assar Westerlund <assar@sics.se>
 * Compile and run it using gcc -O2 -fno-schedule-insns and
 * gcc -O2 -fschedule-insns.
 */
main()
{
  const int clone[] = {1, 2, 0};
  const int *q;
  q = clone;
  if (*q) {
    return 0;
  }
  return 1;
}], mfx_cv_prog_gcc_bug_schedule_insns=no, mfx_cv_prog_gcc_bug_schedule_insns=yes)])
CFLAGS=$mfx_save_cflags
fi
MFX_PROG_GCC_BUG_SCHEDULE_INSNS=$mfx_cv_prog_gcc_bug_schedule_insns
AC_SUBST(MFX_PROG_GCC_BUG_SCHEDULE_INSNS)dnl
])


## --------------------------------------------------------- ##
## Adapted from zsh.                                         ##
## --------------------------------------------------------- ##

dnl  Checking if compiler correctly cast signed to unsigned.
AC_DEFUN(mfx_PROG_CC_BUG_SIGNED_TO_UNSIGNED_CASTING,
[AC_REQUIRE([AC_PROG_CC])dnl
AC_REQUIRE([AC_PROG_CPP])dnl
AC_CACHE_CHECK(whether signed to unsigned casting is broken,
mfx_cv_prog_cc_bug_signed_to_unsigned_casting,
[AC_TRY_RUN([main(){return((int)(unsigned char)((char) -1) != 255);}],
  mfx_cv_prog_cc_bug_signed_to_unsigned_casting=no,
  mfx_cv_prog_cc_bug_signed_to_unsigned_casting=yes)])
MFX_PROC_CC_BUG_SIGNED_TO_UNSIGNED_CASTING=$mfx_cv_prog_cc_bug_signed_to_unsigned_casting
AC_SUBST(MFX_PROC_CC_BUG_SIGNED_TO_UNSIGNED_CASTING)dnl
if test "$mfx_cv_prog_cc_bug_signed_to_unsigned_casting" = yes; then
  AC_DEFINE(MFX_PROG_CC_BUG_SIGNED_TO_UNSIGNED_CASTING)
fi
])


## --------------------------------------------------------- ##
## Check for 8-bit clean memcmp.                             ##
## Adapted from AC_FUNC_MEMCMP.                              ##
## --------------------------------------------------------- ##

AC_DEFUN(mfx_FUNC_MEMCMP,
[AC_CACHE_CHECK(for 8-bit clean memcmp, mfx_cv_func_memcmp,
[AC_TRY_RUN([
main()
{
  char c0 = 0x40, c1 = 0x80, c2 = 0x81;
  exit(memcmp(&c0, &c2, 1) < 0 && memcmp(&c1, &c2, 1) < 0 ? 0 : 1);
}
], mfx_cv_func_memcmp=yes, mfx_cv_func_memcmp=no, mfx_cv_func_memcmp=no)])
if test "$mfx_cv_func_memcmp" = no; then
  AC_DEFINE(MFX_MEMCMP_BROKEN)
fi
])


## --------------------------------------------------------- ##
## Check the byte order.                                     ##
## Adapted from AC_C_BIGENDIAN.                              ##
## --------------------------------------------------------- ##

AC_DEFUN(mfx_C_BYTE_ORDER,
[AC_CACHE_CHECK(the byte order, mfx_cv_c_byte_order,
[mfx_cv_c_byte_order=unknown
AC_TRY_RUN([main () {
  /* Are we little or big endian?  From Harbison&Steele.  */
  union
  {
    long l;
    char c[sizeof (long)];
  } u;
  u.l = 1;
  exit (u.c[sizeof (long) - 1] == 1);
}], mfx_cv_c_byte_order=1234, mfx_cv_c_byte_order=4321)
])
if test $mfx_cv_c_byte_order = 1234; then
  AC_DEFINE_UNQUOTED(MFX_BYTE_ORDER,1234)
fi
if test $mfx_cv_c_byte_order = 4321; then
  AC_DEFINE_UNQUOTED(MFX_BYTE_ORDER,4321)
fi
])


## --------------------------------------------------------- ##
## Check the alignment of the assembler.                     ##
## Adapted from AC_CHECK_SIZEOF.                             ##
## --------------------------------------------------------- ##

AC_DEFUN(mfx_ASM_ALIGN,
[AC_CACHE_CHECK(the alignment of the assembler, mfx_cv_asm_align,
[AC_TRY_RUN([#include <stdio.h>
main()
{
#if defined(__GNUC__)
  extern char mfx_a1 __asm__("mfx_a1");
  extern char mfx_a2 __asm__("mfx_a2");
  long l = &mfx_a2 - &mfx_a1;
  FILE *f = fopen("conftestval", "w");
  if (!f) exit(1);
  fprintf(f, "%ld\n", l);
  exit(0);
  __asm__ __volatile__ ("
  .align 4
mfx_a1:
  .byte 0
  .align 4
mfx_a2:
  ");
#else
  exit(2);
#endif
}], mfx_cv_asm_align=`cat conftestval`, mfx_cv_asm_align=0)
])
if test $mfx_cv_asm_align = 16; then
  AC_DEFINE(MFX_ASM_ALIGN_PTWO)
else
  AC_DEFINE(MFX_ASM_ALIGN_BYTES)
fi
])

