//+----------------------------------------------------------------------------+
//| MODEMENGINE.HPP                                                            |
//|                                                                            |
//| COPYRIGHT:                                                                 |
//| ----------                                                                 |
//|  Copyright (C) Sacha Prins, 1995, 1996.                                    |
//|                                                                            |
//| DISCLAIMER OF WARRANTIES:                                                  |
//| -------------------------                                                  |
//|  The following [enclosed] code is code created by Sacha Prins.             |
//|  The code is provided "AS IS", without warranty of any kind. Sacha Prins   |
//|  shall not be liable for any damages arising out of your use of the        |
//|  [enclosed] code.                                                          |
//|                                                                            |
//| REVISION LEVEL: 1.0                                                        |
//| ---------------                                                            |
//|    22-jun-1996: Initial release to the public                              |
//+----------------------------------------------------------------------------+
#ifndef __MODEM_ENGINE__HPP__
#define __MODEM_ENGINE__HPP__

#define INCL_DOSSEMAPHORES
#define INCL_DOSFILEMGR
#define INCL_DOSDEVIOCTL
#define INCL_DOSDEVICES
#define INCL_DOSPROCESS
#define INCL_DOSSESMGR
#define INCL_DOSQUEUES
#define INCL_DOSERRORS
#include <os2.h>

#define AT              "AT"
#define RETURN          13
#define PLAYEND         " "

//*****************************************************
// CLASS definition MODEM_ENGINE
//*****************************************************
class MODEM_ENGINE {

   public:

        enum STATE { idle=0, Vcon, connected };
        enum CONNECTSTATE { transmit=0, receive };
        enum BITRANGE { two=2, three, four, eight };
        enum LINE { line=0, phone, speaker, mic, lineMonitor };
        enum _MODEMRESPONSE {   ok=0, connect, ring, no_carrier, error, no_dialtone=6, busy,
                                none=100, unknown, newCommand, atCommand, vcon };
        enum DEVICE { data=0, class1fax=1, class2fax=2, voice=8 };
        enum RESULTCODE { noerror=0, errorOPENCOM, errorCREATEMESSAGEQUEUE, errorCREATEDLEQUEUE, errorSENDSTRING };
        enum MESSAGES { vmsetdevice=0, vmsetbits, vmsetdeadmantimer, vmsetspeed, vmsetsilencedetection,
                        vmsetsilencedetectionvalue, vmsetsilencedeletion, vmsetline, vmbeep, manswer,
                        vmtransmit, vmreceive, vmstoptransmit, vmstopreceive, minitialize, mhangup, quit,
                        vmquerydevice, vmquerymodel, vmquerymanufacturer, vmqueryrevision,vmquerycompression, vmquerydevices};

        enum FLOW_CONTROL { fc_none=0, fc_rtscts, fc_xonxoff, fc_rtscts_xonxoff};

        struct MESSAGE {
           MESSAGES     message;
           PVOID        data;
        };

        struct MODEMRESPONSE {
           _MODEMRESPONSE       code;
           CHAR                 verbose[100];
        };

        _Export MODEM_ENGINE(PCHAR, FLOW_CONTROL, int);
        _Export ~MODEM_ENGINE();

        void _Export           vmSetDevice (DEVICE d=voice);
        DEVICE                 vmGetDevice () { return device; };

        void _Export           vmSetBits (BITRANGE b=four);
        BITRANGE               vmGetBits () { return bitRange; };

        void _Export           vmSetDeadmanTimer (BYTE b=0);
        BYTE                   vmGetDeadmanTimer () { return deadMan; };

        void _Export           vmSetSpeed (BYTE b=16);
        BYTE                   vmGetSpeed () { return vmSpeed; };

        void _Export           vmSetSilenceDetection (BOOL    b=TRUE);
        BOOL                   vmGetSilenceDetection () { return silenceDetection; };

        void _Export           vmSetSilenceDetectionValue (BYTE b=60);        //'in tens of seconds'
        BYTE                   vmGetSilenceDetectionValue () { return silenceDetectionValue; };

        void _Export           vmSetSilenceDeletion (BOOL    b=FALSE);
        BOOL                   vmGetSilenceDeletion () { return silenceDeletion; };

        void _Export           vmSetLine (LINE l=phone);
        LINE                   vmGetLine () { return line; };

        void _Export           vmBeep ();
        void _Export           vmTransmit (HFILE&);
        void _Export           vmReceive (HFILE);
        void _Export           vmStopTransmit ();
        void _Export           vmStopReceive ();

        void _Export           vmQueryDevice ();
        void _Export           vmQueryModel ();
        void _Export           vmQueryManufacturer ();
        void _Export           vmQueryRevision ();
        void _Export           vmQueryCompression ();
        void _Export           vmQueryDevices ();

        void _Export           mInitialize ();
        void _Export           mHangup ();
        void _Export           mAnswer ();

        void _Export           mDropDTR ();

        RESULTCODE _Export     mResultCode ();

        MODEMRESPONSE _Export  mWaitForModemResponse (BYTE tsec=30); // Wait for a response from the
                                                                    // modem for 'sec' seconds/10

        CHAR _Export           mWaitForDLECode (BYTE tsec=30);         //Ditto

        void _Export           mWaitForModemResponseAndDLECode (MODEMRESPONSE&, CHAR&, BYTE tsec=30);

        MODEMRESPONSE _Export  mModemResponse ();

        void _Export    messageLoop ();
        void _Export    RxLoop ();


   protected:

        void _Export           mSendString (PCHAR);
        void _Export           mSendString (CHAR);
        void                   mSendATString (PCHAR p) { mSendString (AT);
                                                         mSendString (p);
                                                         mSendString (RETURN); };

   private:

        HFILE           hcom, hfile;
        PCHAR           deviceName;
        HQUEUE          hMessageQueue, hDLEQueue;
        HMTX            hModemResponseSem, hResultCodeSem, hConnectStateSem;
        HEV             hevModemResponseSem, hevModemResponseSeenSem;
        TID             tidRxLoopThread, tidMessageLoopThread;
        STATE           state;
        CONNECTSTATE    connectState;
        MODEMRESPONSE   modemResponse;
        RESULTCODE      resultCode;

        DEVICE          device;
        BITRANGE        bitRange;
        LINE            vmLine;
        BYTE            deadMan, vmSpeed;
        BOOL            silenceDeletion, silenceDetection, bRunRxLoop, bRunMessageLoop,
                        operational;
        BYTE            silenceDetectionValue;

        BOOL _Export    mOpenCOM (FLOW_CONTROL);
};

#endif

