/*************************************************************************
*
* filename		: editor.h
*
* description	: header file for class EDITOR
*
* exp. types	: struct MLE_LIST	- chain MLEs together
*				  class  EDITOR		- handle many MLEs
*
* used classes	: class  MLE
*
* copyright (C) 1993 Jrg Caumanns (caumanns@cs.tu-berlin.de)
*
*************************************************************************/
#ifndef _MLE_INCLUDED
#define _MLE_INCLUDED

#include <os2def.h>

/*
* shellposition parameters
*/
#define MLE_DISTANCE 		32		// distance between the upper right
									// corners of two MLEs (in pels)
#define MLE_XSIZE			60		// MLE default x-size (% of desktop)
#define MLE_YSIZE			60      // MLE default y-size (% of desktop)

/*
* Creation Flags
*/
#define MLE_HIDE			1		// create the MLE invisible
#define MLE_MAXIMIZE		2		// create the MLE with maximum size
#define MLE_MINIMIZE		4		// create the MLE with minimum size
#define MLE_NEWFILE			8		// don't load a file to the MLE

/*
* Size and position flags
*/
#define MLE_SIZEPOS_SIZE	1		// change the MLE-size
#define MLE_SIZEPOS_POS		2		// change the MLE-position
#define MLE_SIZEPOS_MAX		4		// maximize the MLE
#define MLE_SIZEPOS_MIN		8		// minimize the MLE

/*************************************************************************
*
* class	: MLE (Multi-Line Entryfield)
*
* descr.: Create and manage MLEs
*
* method: OpenFile		: Create an MLE and load a file to it. If no
*						  filename is given the action depends on
*						  the flag parameter: if MLE_NEWFILE is set
*						  an empty MLE is created, otherwise the user
*						  is asked for a filename ("open"-dialogbox).
*						  If flag MLE_HIDE is set, the MLE is created
*						  invisible. This may be useful if you want
*						  to change some attributes of the MLE (e.g.
*						  color, size, ...) before the MLE is displayed.
*         CloseFile		: Close the MLE. If the contents of the MLE
*						  has changed, the user is asked if the
*						  changes can be discarded or not.
*         SaveFile		: Save the contents of the MLE to the filesystem.
*						  If no filename was given at open-time
*						  the "save as"-dialogbox appears.
*		  SaveFileAs	: Save the contents of the MLE to a file that
*						  name is given by the user ("save as"-dialogbox).
*						  If the file already exists, the user is asked
*						  if it should be overwritten.
*		  Cut			: Remove the selected text from the  MLE and put
*						  it in the clipboard.
*		  Copy          : Copy the selected text from the active MLE to the
*						  clipboard.
*		  Paste			: Insert text from the clipboard at the cursor-
*						  position of the MLE.
*		  Clear			: Delete the selected text of the MLE.
*         Show			: Depending on the argument the MLE is shown (TRUE)
*						  or hidden (FALSE).
*		  SetSizeAndPosition : Change size and/or position of the MLE.
*						  If the flag MLE_SIZEPOS_SIZE is set the size is
*						  changed, if MLE_SIZEPOS_POS is set the MLE is
*						  moved. If both are set, the MLE is moved and
*						  resized. If MLE_SIZEPOS_MAX or MLE_SIZEPOS_MIN
*						  is set the MLE is maximized (minimized).
*		  SetSize		: Change only the MLE's size
*		  SetPosition	: Move the MLE.
*		  SetColor		: Change foreground and background color of the
*						  MLE.
*		  GetColor		: Query foreground and background color of the
*						  MLE.
*		  GetText		: Copy the contents of the MLE to a buffer.
*						  GetText allocates the buffer big enough to
*						  hold the text. The buffer must be freed by
*						  application via DosFreeMem.
*         Print			: Insert text at the current cursor position.
*						  The syntax is the same as of 'printf'.
*         Touched		: Check if the contents of the MLE changed.
*         TouchFile		: 'Touch' the MLE.
*		  Activate		: Set this MLE as the active MLE.
*         SetClosed		: Clear the 'fActive'-flag (only for internal use)
*		  LoadedFile	: Get the path of the file that is loaded to
*						  the MLE
*		  ActiveMLE		: Get the handle of the MLE that has the focus.
*
* uses  : [none]
*
*************************************************************************/
class MLE	{
		HWND  hwnd;					// frame window handle
		HWND  hwndClient;			// client area handle
		CHAR  *pszLoadedFile;		// path of loaded file
		ULONG ulFlags;				// flags
		BOOL  fTouched;				// TRUE if MLE contents changed
		BOOL  fAlive;				// TRUE if MLE not closed
		LONG  clrForeground;		// foreground color
		LONG  clrBackground;		// background color
		static MLE *pmleActive;		// MLE with focus
	public:
			 MLE(VOID);
		BOOL OpenFile(CHAR *pszFile, ULONG ulf = 0);
		BOOL CloseFile(VOID);
		BOOL SaveFile(VOID);
		BOOL SaveFileAs(VOID);
		VOID Cut(VOID);
		VOID Copy(VOID);
		VOID Paste(VOID);
		VOID Clear(VOID);
		VOID Show(BOOL f);
		VOID SetSizeAndPosition(INT x,INT y,INT cx,INT cy,
							ULONG ulFlags = MLE_SIZEPOS_SIZE | MLE_SIZEPOS_POS);
		VOID SetSize(INT cx, INT cy);
		VOID SetPosition(INT x, INT y);
		VOID SetColor(LONG clrFg, LONG clrBg);
		VOID GetColor(LONG *pclrFg, LONG *pclrBg);
		BOOL GetText(CHAR **ppszBuffer);
		VOID Print(CHAR *pszMask, ...);
		BOOL Touched(VOID);
		VOID TouchFile(BOOL);
		VOID Activate(VOID);
		VOID SetClosed(VOID);
		CHAR *LoadedFile(VOID);
		MLE  *ActiveMLE(VOID);
		};


/*
* include inline implementation of some methods
*/
#include "mle.inl"

#endif	// !_MLE_INCLUDED
