

#include "menudrv.h"
#include "ids.h"

#include "appwin.h"
#include "ui/menu.h"
#include "ui/applic.h"
#include "ui/stddlg.h"
#include "base/strgseq.h"

typedef UI_EventBinding2 <MenuDriver> MenuBinding;
#if defined(__GNUC__)
template class UI_EventBinding2 <MenuDriver>; // Instantiate the binding
#endif


UI_MenuItemDescriptor FileMenu [] = {    // File pull-down menu
    {"&Open..."       , ID_OPEN,     NULL      }
  , {UIMenu_Separator , NULL   ,     NULL      }
  , {"&Quit"          , ID_QUIT,     NULL      }
  , {NULL             , 0      ,     NULL      }
};

UI_MenuItemDescriptor HelpMenu [] = {   // Help pull-down menu
    {"&About..."      , ID_ABOUT}
  , {NULL             , 0     }
};


UI_MenuItemDescriptor MainMenuDesc [] = {   // Main menu bar
    {"&File"          , ID_FILE ,  FileMenu }
  , {"&Help"          , ID_HELP ,  HelpMenu}
  , {NULL             ,        0,  NULL    }
};

struct DispatcherStruct {
    UI_ViewID              menu_id;
    MenuBinding::MethodPtr method;
    UI_EventType           event;
} FAR dispatch [] = {
    {ID_OPEN,     MenuDriver::OpenFile,       Event_Select}      
  , {ID_ABOUT,    MenuDriver::About,          Event_Select}           
  , {ID_QUIT,     MenuDriver::Quit,           Event_Select}
};



MenuDriver::MenuDriver (UI_CompositeVObject* root)
{
    _menu =  new UI_MenuBar (root, MainMenuDesc);
    for (short i = 0; i < sizeof dispatch/sizeof (DispatcherStruct); i++) {
        UI_ViewID id = dispatch[i].menu_id;
        MenuBinding bind (this, dispatch[i].method, id);
        (*_menu)[id]->AddEventDependent (dispatch[i].event, bind);
    }
}


bool MenuDriver::OpenFile (UI_Event&, UI_ViewID)
{
    static CL_String initialDir = "";
    AppWindow* root = (AppWindow *)YACLApp()->MainWindow();
    CL_String s = UI_FileSelectDialog ((UI_VisualObject*) root, 
                                        initialDir.AsPtr(), "Open file",
                                        "*.bmp");
    if (s != "") {
        root->Draw(s);
        
        // Remember the last directory accessed
#if defined(__X_MOTIF__)
        CL_String dirSeparator = "/";
#else
        CL_String dirSeparator = "\\";
#endif
        CL_StringSequence sq = s.Split(dirSeparator);
        long n = sq.Size();
        initialDir = "";
        if (n > 0) {
            initialDir = sq[0];
            for (short i = 1; i < n-1; i++)
                initialDir += dirSeparator + sq[i];
        }
//      initialDir += "\\*.bmp";
    }
        
    return TRUE;
}


bool MenuDriver::About (UI_Event&, UI_ViewID)
{
    UI_StandardDialog ("A simple bitmap viewer using YACL, \nby T.T.Ton@massey.ac.nz",
                       "About BitmapViewer...", 
                       YACLApp()->MainWindow(),
                       UIS_Ok, UIS_Information);
    return TRUE;
}


bool MenuDriver::Quit (UI_Event&, UI_ViewID)
{
    YACLApp()->End();
    return TRUE;
}
