
#include "sysvals.h"

#if defined(__OS2__)
# define INCL_WINSYS
# include <os2.h>

#elif defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
# include <windows.h>

#endif


SysValues::SysValues()
{
#if defined(__OS2__)
    sizeBorderHeight = WinQuerySysValue(HWND_DESKTOP, SV_CYSIZEBORDER);
    sizeBorderWidth = WinQuerySysValue(HWND_DESKTOP, SV_CXSIZEBORDER);
    titleBarHeight = WinQuerySysValue(HWND_DESKTOP, SV_CYTITLEBAR);
    menuBarHeight = WinQuerySysValue(HWND_DESKTOP, SV_CYMENU);
    scrollBarHeight = WinQuerySysValue(HWND_DESKTOP, SV_CYHSCROLL);
    scrollBarWidth = WinQuerySysValue(HWND_DESKTOP, SV_CXVSCROLL);
    sysMenuButtonWidth = WinQuerySysValue(HWND_DESKTOP, SV_CXMINMAXBUTTON) / 2;
    iconHeight = WinQuerySysValue(HWND_DESKTOP, SV_CYICON);
    iconTextWidth = WinQuerySysValue(HWND_DESKTOP, SV_CXICONTEXTWIDTH);
#elif defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
    sizeBorderHeight = GetSystemMetrics(SM_CYFRAME);
    sizeBorderWidth = GetSystemMetrics(SM_CXFRAME);
    titleBarHeight = GetSystemMetrics(SM_CYCAPTION);
    menuBarHeight = GetSystemMetrics(SM_CYMENU);
    scrollBarHeight = GetSystemMetrics(SM_CYHSCROLL);
    scrollBarWidth = GetSystemMetrics(SM_CXVSCROLL);
    sysMenuButtonWidth = GetSystemMetrics(SM_CXSIZE);
    iconHeight = GetSystemMetrics(SM_CYICON);
    iconTextWidth = GetSystemMetrics(SM_CXICONSPACING);
#elif defined(__X_MOTIF__)
    // I make up arbitrary values here
    sizeBorderHeight = 3;
    sizeBorderWidth = 3;
    titleBarHeight = 12;
    menuBarHeight = 12;
    scrollBarHeight = 12;
    scrollBarWidth = 12;
    sysMenuButtonWidth = 12;
    iconHeight = 24;
    iconTextWidth = 16;
#endif            
}


