

/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



#include "draghndl.h"
#include "vobjset.h"
#include "vobjdesc.h"
#include "appwin.h"

#include "ui/cntroler.h"
#include "ui/dsplsurf.h"
#include "ui/pen.h"

typedef UI_EventBinding1<DragHandler> DragBind;
#if defined(__GNUC__)
template class UI_EventBinding1<DragHandler>;
#endif

DragHandler::DragHandler (AppWindow* v,
                          const CL_AbstractBinding& finish)
: _client (v)
{
    DragBind down (this, &DragHandler::_MouseDownEvt);
    _client->AddEventDependent (Event_LButtonPress, down);
    DragBind move (this, &DragHandler::_MouseMoveEvt);
    _client->AddEventDependent (Event_MouseMove, move);
    DragBind up   (this, &DragHandler::_MouseUpEvt);
    _client->AddEventDependent (Event_LButtonRelease, up);
    _finishBind = (CL_AbstractBinding*) finish.Clone();
    _active = FALSE;
}


DragHandler::~DragHandler ()
{
    if (_finishBind)
        delete _finishBind;
}

void DragHandler::SetActiveState (bool state)
{
    _active = state;
}


bool DragHandler::_MouseDownEvt (UI_Event& evt)
{
    if (!_active || !_client->DisplaySurface())
        return TRUE;
    UI_DisplaySurface& sfc = *(_client->DisplaySurface());
    //    sfc.SaveState ();
    _modeChanged = FALSE; // modeChanged is used to put the DisplaySurface
                          // into XOR mode at the first mouse move event (if
                          // there is one) following the mouse down
                          // event. If there is no mouse move event, we
                          // don't change modes.
    _MouseDown (sfc, evt.Position());
    return TRUE;
}

bool DragHandler::_MouseMoveEvt (UI_Event& evt)
{
    if (!_active || !_client->DisplaySurface())
        return TRUE;
    if (!_modeChanged) {
        UI_DisplaySurface& sfc = *(_client->DisplaySurface());
        sfc.Pen().Pattern (UIPen_Dot);
        sfc.Pen().Color   (UIColor_MediumGray);
        sfc.Mode (UI_DisplaySurface::GMode_Xor);
        _modeChanged = TRUE;
    }
    UI_DisplaySurface& sfc = *(_client->DisplaySurface());
    _MouseMove (sfc, evt.Position());
    return TRUE;
}

bool DragHandler::_MouseUpEvt (UI_Event& evt)
{
    if (!_active || !_client->DisplaySurface())
        return TRUE;
    UI_DisplaySurface& sfc = *(_client->DisplaySurface());
    _MouseUp (sfc, evt.Position());
    sfc.Mode (UI_DisplaySurface::GMode_Copy);
    sfc.Pen().Color (UIColor_Black);
    sfc.Pen().Pattern (UIPen_Solid);
    if (_finishBind)
        _finishBind->Execute (*this);
    return TRUE;
}








RectanglePainter::RectanglePainter
    (AppWindow* v, const CL_AbstractBinding& finish)
: DragHandler (v, finish)
{
}


bool RectanglePainter::_MouseDown (UI_DisplaySurface& , const UI_Point& p)
{
    _downEventPoint = p;
    _rect = UI_Rectangle (_downEventPoint, 0, 0);
    return TRUE;
}


bool RectanglePainter::_MouseMove (UI_DisplaySurface& sfc, const UI_Point& p)
{
    //    CL_Error::Warning ("0: rectangle %s\n", _rect.AsString().AsPtr());
    long wd = p.XCoord() - _downEventPoint.XCoord();
    long ht = p.YCoord() - _downEventPoint.YCoord();
    // CL_Error::Warning ("1: RectPainter rectangle %s\n",
    // _rect.AsString().AsPtr()); DEBUG
    sfc.DrawRectangle (_rect); // Erase the old rectangle if there was one
    _rect = UI_Rectangle (_downEventPoint, wd, ht);
    sfc.DrawRectangle (_rect);        // Draw the new rectangle
    // CL_Error::Warning ("2: rectangle %s\n", _rect.AsString().AsPtr());
    return TRUE;
}

bool RectanglePainter::_MouseUp (UI_DisplaySurface& sfc, const UI_Point& p)
{
    sfc.DrawRectangle (_rect);   // Erase the old rectangle
    // CL_Error::Warning ("3: rectangle %s\n", _rect.AsString().AsPtr());
    _rect = UI_Rectangle (_downEventPoint, p.XCoord() -
                          _downEventPoint.XCoord(),
                          p.YCoord() - _downEventPoint.YCoord());
    return TRUE;
}










MoveHandler::MoveHandler
    (AppWindow* v, const CL_AbstractBinding& finish)
: DragHandler (v, finish), _vector (0, 0)
{
}


bool MoveHandler::_MouseDown (UI_DisplaySurface&, const UI_Point& p)
{
    _downEventPoint = p;
    _vector = UI_Vector (0, 0);
    return TRUE;
}


bool MoveHandler::_MouseMove (UI_DisplaySurface& sfc, const UI_Point& p)
{
    if (_vector.X() != 0 || _vector.Y() != 0)
        _DrawRectangles (sfc, _vector);  // Erase the old rectangles if any
    _vector = UI_Vector (p) - _downEventPoint;
    _DrawRectangles (sfc, _vector);  // Draw the new ones
    return TRUE;
}


void MoveHandler::_DrawRectangles (UI_DisplaySurface& sfc,
                                   const UI_Vector& vec)
{
    VObjSetIterator itr (_client->Editor().Selection());
    while (itr.More()) {
        VObjDesc* v = itr.Next();
        sfc.DrawRectangle (v->_shape + vec);
    }
}


bool MoveHandler::_MouseUp  (UI_DisplaySurface& sfc, const UI_Point& p)
{
    _vector = UI_Vector (p) - _downEventPoint;
    _DrawRectangles (sfc, _vector);
    return TRUE;
}









SizeHandler::SizeHandler
    (AppWindow* v, const CL_AbstractBinding& finish)
: DragHandler (v, finish)
{
}


void SizeHandler::SetSizingParams (VObjDesc* vObj, const UI_Point&)
{
    if (!vObj)
        CL_Error::Fatal ("SizeHandler::SetSizingParams: Internal error");
    _vObj    = vObj;
}


bool SizeHandler::_MouseDown (UI_DisplaySurface&, const UI_Point& p)
{
    // Decide the drag direction:
    _dir  = _vObj->Direction (p);
    _rect = _vObj->_shape;
    return TRUE;
}




bool SizeHandler::_MouseMove (UI_DisplaySurface& sfc, const UI_Point& p)
{
    if (_dir == VObjDesc::Dir_None)
        return TRUE; // Should never happen
    const UI_Rectangle& objRect = _vObj->_shape;
    if (_rect != objRect)
        _rect.DrawOn (sfc); // Erase old rectangle
    long x = p.XCoord(), y = p.YCoord();
    switch (_dir) {
    case VObjDesc::Dir_N:
        _rect = UI_Rectangle (objRect.Left(), y, objRect.Width(),
                              objRect.Bottom() - y + 1);
        break;

    case VObjDesc::Dir_S:
        _rect = UI_Rectangle (objRect.Left(), objRect.Top(),
                              objRect.Width(), y - objRect.Top() + 1);
        break;

    case VObjDesc::Dir_E:
        _rect = UI_Rectangle (objRect.Left(), objRect.Top(),
                              x - objRect.Left() + 1, objRect.Height());
        break;

    case VObjDesc::Dir_W:
        _rect = UI_Rectangle (x, objRect.Top(),
                              objRect.Right() - x + 1, objRect.Height());
        break;

    case VObjDesc::Dir_NE:
        _rect = UI_Rectangle (objRect.Left(), y,
                              x - objRect.Left() + 1,
                              objRect.Bottom() - y + 1);
        break;

    case VObjDesc::Dir_SE:
        _rect = UI_Rectangle (objRect.Left(), objRect.Top(),
                              x - objRect.Left() + 1,
                              y - objRect.Top() + 1);
        break;

    case VObjDesc::Dir_NW:
        _rect = UI_Rectangle (x, y, objRect.Right() - x + 1,
                              objRect.Bottom() - y + 1);
        break;

    case VObjDesc::Dir_SW:
        _rect = UI_Rectangle (x, objRect.Top(), objRect.Right() - x + 1,
                              y - objRect.Top() + 1);
        break;
    }
    _rect.DrawOn (sfc); // Draw the new rectangle
    return TRUE;
}




bool SizeHandler::_MouseUp (UI_DisplaySurface& sfc, const UI_Point&)
{
    if (_rect != _vObj->_shape)
        _rect.DrawOn (sfc); // Erase old rectangle
    return TRUE;
}



UI_CursorType SizeHandler::CursorType (const UI_Point& p)
{
    VObjSetIterator itr (_client->Editor().Selection());
    UI_CursorType c = UICursor_Arrow;
    while (itr.More()) {
        VObjDesc* desc = itr.Next();
        VObjDesc::HitDirection dir = desc->Direction (p);
        switch (dir) {
        case VObjDesc::Dir_N:
        case VObjDesc::Dir_S:
            c = UICursor_NorthSouthArrows;
            break;

        case VObjDesc::Dir_E:
        case VObjDesc::Dir_W:
            c = UICursor_EastWestArrows;
            break;

        case VObjDesc::Dir_NE:
        case VObjDesc::Dir_NW:
        case VObjDesc::Dir_SE:
        case VObjDesc::Dir_SW:
            c = UICursor_UpArrow;
            break;
        }
        if (dir != VObjDesc::Dir_None)
            break;
    }
    return c;
}





