

#ifndef _vobjdesc_h_ /* Sun Dec  3 10:51:49 1995 */
#define _vobjdesc_h_


/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



#include "ui/viewdesc.h"
#include "ui/rectangl.h"

class VObjDesc: public CL_Object {

public:
    VObjDesc (UI_ViewType type, UI_ViewID id, const UI_Rectangle& rect);

    VObjDesc () {_type = View_None; _id = 0;};

    VObjDesc (const VObjDesc&);
    
    ~VObjDesc () {};

    short Compare (const VObjDesc&) const;

    short Compare (const CL_Object&) const;
    
    enum HitDirection {Dir_None, Dir_N, Dir_S, Dir_E, Dir_W, Dir_NE,
                       Dir_SE, Dir_SW, Dir_NW};

    HitDirection Direction (const UI_Point& pt)
        const;
    // Return the direction in which {\tt pt} hits this VObjDesc's shape.
    
    
    bool IsHitBy (const UI_Point& clickPoint) const
        {return _shape.Includes (clickPoint) ||
         Direction(clickPoint) != Dir_None;};
    // Return TRUE if {\tt clickPoint} is either contained in this
    // VObjDesc's shape rectangle or hits its boundary.


    CL_String AsString () const;
    
    UI_ViewID     _id;
    UI_ViewType   _type;
    UI_Rectangle  _shape;
    CL_String     _title;
    CL_String     _symbolicName;
    bool          _isTabStop;
};


#endif /* _vobjdesc_h_ */
