
#
# makefile for cfront generated base and memory libraries
#


#
# Get the common cfront make definitions
#
include $(YACLPATH)/control/cfr_sun.ctl


#
# Override PTREP so that it includes the option for instantiating the
# whole template class.  We want to include entire template instantces
# in the library.
#
PTREP=$(PTALL)

#
# BASELIMPLSRCS is needed for cfront template instantiation.
#
# Here's the basic rule for most cfront implementations of templates.
# The template declaration file must have either a .h or .H extension.
# The template definition file must have a corresponding extension.
# For example, if foo.h declares some templates, then the definitions
# *must* appear in foo.c.  If, however, the declarations are in foo.H
# then the definitions *must* be in foo.C.  Otherwise, it is highly
# probable that templates won't get linked correctly.
#
# Note: It is not necessary to compile these sources.  The template
#       instantiation mechanism will do that by including them in the 
#       template file when it builds the templates.  So... don't try to
#       compile these, they are only here to be referenced by the
#       template mechanism.  However, they will be compiled when the
#       template is instantiated, sp they must be correct C++ source.
#
# Note: It's probably best to conform to this style for all platforms
#       since it can be adapted to all non-cfront platforms.
#
BASELIMPLSRCS = \
	basicops.c \
	cmparatr.c \
	map.c      \
	sequence.c \
	set.c      \
	tbtree.c   \
	tree.c     \
	treewalk.c


#
# Stuff needed to make the memory library.
#
MEMILIST = memilist
MEMLIB   = $(YACLLIB)/lib$(MEMORY).a
MEMOBJS  =	\
	memory.o



#
# Stuff needed to make the base library.
#
BASEILIST = baseilst
BASELIB   = $(YACLLIB)/lib$(BASE).a
BASEOBJS  =    \
	bitset.o      \
	bytarray.o    \
	bytestrm.o    \
	bytstrng.o    \
	clntset.o     \
	date.o        \
	error.o       \
	gbtree.o      \
	genseq.o      \
	integer.o     \
	intseq.o      \
	intset.o      \
	map.o         \
	object.o      \
	objseq.o      \
	objset.o      \
        regexpr.o     \
        segseq.o      \
	set.o         \
	stream.o      \
	strgseq.o     \
	strgset.o     \
	string.o      \
	strsplit.o    \
	tbtree.o      \
	timeofda.o    \
	tree.o        \
	version.o


#
# Group libraries.  Also, this macro is used in cfr_sun.ctl
#
LIBRARIES = $(BASELIB) $(MEMLIB)


#
# Default build target builds all libraries
#
all: $(LIBRARIES)
	@echo Base Library Contents
	@ar ts $(BASELIB)
	@echo Memory Library Contents
	@ar ts $(MEMLIB)


#
# Build the base library.  $(BASEILIST) is a file which contains the
# file names for object files generated by the template instantiation
# process.
#
$(BASELIB): $(BASEILIST)
	ar rucv $(BASELIB) $(BASEOBJS) `cat $(BASEILIST)`
	@$(RANLIB) $(BASELIB) > /dev/null


#
# Build the memory library.  $(MEMILIST) is similar to $(BASEILIST).
#
$(MEMLIB): $(MEMILIST)
	ar rucv $(MEMLIB) $(MEMOBJS) `cat $(MEMILIST)`
	@$(RANLIB) $(MEMLIB) > /dev/null


#
# Create the file which contains filenames for all template
# instantiation generated object files.
# The object files are generated by invoking the C++ compiler on all
# the objects.  The $(PTDUMP) option calls the ptlinker to do the
# template instantiations, and dumps a list of all the resulting object
# files into the file given as an argument to the option.
# Note the need to create an empty file if there is nothing real for
# ptlink to do.
#
# Note the need for BASELIMPLSRCS as a dependency.  FIrst, it guarantees
# that they get created.  Second, if the *imp.cxx file gets modified,
# we want the templates to be rebuilt and since the BASELIMPLSRCS are
# directly dependent on them, if they get modified, the ptlink phase
# will get done to update the library.
#
$(BASEILIST): $(BASELIMPLSRCS) $(BASEOBJS)
	rm -f $(BASEILIST)
	$(CC) $(PTDUMP)$(BASEILIST) $(LNKOPTS) $(BASEOBJS)
	if [ ! -r $(BASEILIST) ]; then cat /dev/null > $(BASEILIST); fi


#
# See $(BASEILIST)
#
$(MEMILIST): $(MEMOBJS)
	rm -f $(MEMILIST)
	$(CC) $(CCOPTS) $(PTDUMP)$(MEMILIST) $(MEMOBJS)
	if [ ! -r $(MEMILIST) ]; then cat /dev/null > $(MEMILIST); fi


#
# The following rules copy implementation files into files which the
# template instantiation stuff will recognize (se comments for
# BASELIMPLSRCS).
#
# Of course, it would be alot easier to have the implementation files
# be here in the first place.  However, I'm trying to do as little
# change as possible to the overall scope (I'll leave that to the
# YACL folk, depending on how they want it).
#
basicops.c: basicops.cxx
	@echo "Creating template implementation file $@"
	-@rm -f $@
	@echo "#define __CFRONT_BASICOPS_IMPL__" > $@
	@cat basicops.cxx >> $@

cmparatr.c: cmparatr.cxx
	@echo "Creating template implementation file $@"
	-@rm -f $@
	@echo "#define __CFRONT_CMPARATR_IMPL__" > $@
	@cat cmparatr.cxx >> $@

map.c: mapimp.cxx
	@echo "Creating template implementation file $@"
	-@rm -f $@
	@echo "#define __CFRONT_MAP_IMPL__" > $@
	@cat mapimp.cxx >> $@

sequence.c: seqimp.cxx
	@echo "Creating template implementation file $@"
	-@rm -f $@
	@echo "#define __CFRONT_SEQUENCE_IMPL__" > $@
	@cat seqimp.cxx >> $@

set.c: setimp.cxx
	@echo "Creating template implementation file $@"
	-@rm -f $@
	@echo "#define __CFRONT_SET_IMPL__" > $@
	@cat setimp.cxx >> $@

tbtree.c: tbtreimp.cxx
	@echo "Creating template implementation file $@"
	-@rm -f $@
	@echo "#define __CFRONT_TBTREE_IMPL__" > $@
	@cat tbtreimp.cxx >> $@

tree.c: treeimp.cxx
	@echo "Creating template implementation file $@"
	-@rm -f $@
	@echo "#define __CFRONT_TREE_IMPL__" > $@
	@cat treeimp.cxx >> $@

treewalk.c: treewalk.cxx
	@echo "Creating template implementation file $@"
	-@rm -f $@
	@echo "#define __CFRONT_TREEWALK_IMPL__" > $@
	@cat treewalk.cxx >> $@


#
# Clean out all files generated by runs of this makefile
#
CLEANFILES = \
	$(BASELIMPLSRCS) \
	$(BASEILIST) \
	$(MEMILIST)

