

// A very simple reminder program: picks out those lines in the input file
// whose first field looks like a date (without year) that is within 5 days.
// For example, if today is Feb 13, and the input file looks like:
//                1/1   New year's day
//                2/17  Jane's birthday
//                4/15  IRS day
//                2/15  Mid-February
// The program prints the second and fourth lines.
//
// To test, invoke with:
//
//           remind < data.txt
//
// M. A. Sridhar
// Feb 13, 1994



#include "base/string.h"
#include "base/date.h"

#include <iostream.h>


void main ()
{
    CL_Date today = CL_Date::Today();
    CL_String s;
    while (s.ReadLine (cin)) { // Read from standard input
        if (s.Size() <= 0) continue; // Allow for empty lines
        CL_String fld[2];
        s.Split (fld, 2);
        short month = fld[0].Field (1, "/").AsLong();
        short day   = fld[0].Field (2, "/").AsLong();
        if (month >= 1 && month <= 12 && day >= 1 && day <=
            CL_Date::DaysInMonth (month, today.Year())) {
            CL_Date date (today.Year(), month, day);
            if (date.IsLegal() && date.IsBetween (today, today+4))
                cout << date << ":" << fld[1] << endl;
        }
    }
}

