

include $(YACLPATH)/control/cfr_sgi.ctl


LIBS = libdir make_base make_io make_ui

.PHONY: libdir make_base make_io make_ui

yacl: libdir $(LIBS)



libdir:
	-mkdir $(YACLPATH)/lib
	-mkdir $(YACLPATH)/lib/$(YACLPLATFORM)





make_base:
	- cd base && make -f cfr_sgi.mak && cd .. 


make_io:
	- cd io && make -f cfr_sgi.mak && cd .. 


make_ui:
	- cd ui && make -f cfr_sgi.mak && cd .. 


make_basedemos:
	- cd basedemo && make -f cfr_sgi.mak && cd ..


make_uidemos:
	- cd uidemo && make -f cfr_sgi.mak && cd ..


everything: libdir make_base make_io make_ui make_basedemos make_uidemos


clean:
	-rm -f base/*.o io/*.o ui/*.o lib/$(YACLPLATFORM)/*.a
	- cd uidemo && make -f cfr_sgi.mak clean && cd ..
        

        



ZIP = zip

zip:
	rm -f yacl.zip
	find . \! \( -perm -0111 -o -name '*.o' -o -name '*.a' \) -print | \
	sort  | \
	$(ZIP) yacl.zip -@


uizip:
	rm -f yaclui.zip
	(find ./control ./ui ./uidemo \! \( -perm -0111 -o -name '*.o' \
        -o -name '*.a' \)  -print; ls ./makefile.* ./*.txt)| sort | \
	$(ZIP) yaclui.zip -@



