
#
# makefile for cfront generated YACL release
#
# Author: Jody Hagins (gamecox@magicnet.net)


include $(YACLPATH)/control/cfr_sun.ctl

DESTLIBDIRS = $(YACLPATH)/lib $(YACLPATH)/lib/$(YACLPLATFORM)
LIBDIRS = base io ui
OTHERDIRS = basedemo uidemo

all: everything

yacl: $(DESTLIBDIRS) $(LIBDIRS)

everything: yacl $(OTHERDIRS)

$(DESTLIBDIRS):
	-mkdir $@

$(LIBDIRS) $(OTHERDIRS): .FoRcE
	- cd $@ && make -f cfr_sun.mak && cd .. 

clean: cleanme

cleanme: .FoRcE
	- cd base && make -f cfr_sun.mak clean && cd ..
	- cd io && make -f cfr_sun.mak clean && cd ..
	- cd ui && make -f cfr_sun.mak clean && cd ..
	- cd basedemo && make -f cfr_sun.mak clean && cd ..
	- cd uidemo && make -f cfr_sun.mak clean && cd ..

ZIP = zip

zip:
	rm -f yacl_all.zip
	find . \! \( -perm -0111 -o -name '*.o' -o -name '*.a' \) -print | \
	sort  | \
	$(ZIP) yacl_all.zip -@

changezip:
	rm -f changes.zip
	find . -newer control/cfr_sun.ctl \! \( -perm +u+x \) -print \
		| egrep -v '\.[oa]' | sort  | $(ZIP) changes.zip -@

uizip:
	rm -f yaclui.zip
	(find ./control ./ui ./uidemo \! \( -perm -0111 -o -name '*.o' \
        -o -name '*.a' \)  -print; ls ./makefile.* ./*.txt)| sort | \
	$(ZIP) yaclui.zip -@


