// File: ApplicationWithAccel.c++

/************************************************************************/
/*                                                                      */
/*                    Application with Accelerators                     */
/*                                                                      */
/* Author     : Ludovic Brenta                                          */
/* Date       : 7 Jan 1996                                              */
/* Compiler   : EMX 0.9a (GCC 2.6.3) sous OS/2 3.0                      */
/*                                                                      */
/************************************************************************/


// This was slightly modified from <ui/applic.cxx>

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
#include <dos.h>
#include <windows.h>
#include <ctl3d.h>

#elif defined(__X_MOTIF__)
#if defined(__GNUC__) && __GNUC_MINOR__ >= 7
#include <string.h>    // Without this, the X includes barf
#endif
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <iostream.h>

#elif defined(__OS2__)
#include <stdlib.h>
#define INCL_PM
#define INCL_DOSPROCESS
#include <os2.h>
#endif

#include "ApplicationWithAccel.h"
#include "ControllerWithAccel.h"

#if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)

void UI_ApplicationWithAccel::Initialize
    (HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpCmdln, int nCmdShow)
{
    pid = hInstance;
    _name = CL_String (lpCmdln).Field (1);
    _controller = new UI_ControllerWithAccel ( this );
    _controller->Initialize (hInstance, hPrevInstance, lpCmdln, nCmdShow);

#if defined(DEBUG)
    _DebugWindow = CreateWindow
        ("edit", "DEBUG",
         ES_MULTILINE  | WS_OVERLAPPEDWINDOW | WS_VISIBLE | WS_VSCROLL,
         CW_USEDEFAULT, CW_USEDEFAULT, 500, 400,
         NULL, NULL, hInstance, NULL);
    _DebugFont = CreateFont (14, 0, 0, 0, FW_BOLD, 0, 0, 0, DEFAULT_CHARSET,
                              OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
                              DEFAULT_QUALITY, DEFAULT_PITCH | FF_DONTCARE,
                              "Courier");
    SendMessage (_DebugWindow, WM_SETFONT, (UINT) _DebugFont, 0);
#endif
    Ctl3dRegister (pid);
    Ctl3dAutoSubclass (pid);
}


#elif defined(__X_MOTIF__)
void UI_ApplicationWithAccel::Initialize (int& argc, char* argv[])
{
    CL_StringSequence seq =  CL_String (argv[0]).Split ("/");
    _name = seq[seq.Size()-1];
    _controller = new UI_ControllerWithAccel (this);
    _controller->Initialize (argc, argv);
    _controller->DispatchPendingEvents();
    _display = _controller->AppDisplay ();
}
#elif defined(__OS2__)
void UI_ApplicationWithAccel::Initialize (int /* argc */, char* argv[])
{
    PPIB pib;
    PTIB tib;
    _name = argv[0];
    DosGetInfoBlocks (&tib, &pib);
    pid = pib->pib_ulpid;
    _controller = new UI_ControllerWithAccel (this);
    _controller->Initialize ();
#if defined(DEBUG)
    ulong style = FCF_SHELLPOSITION | FCF_TITLEBAR | FCF_SIZEBORDER |
        FCF_VERTSCROLL;
    HWND dbugWin;
    HWND dbugWinFrame = WinCreateStdWindow
        (HWND_DESKTOP, WS_VISIBLE, &style,
         WC_MLE, (const unsigned char *) "DEBUG", 0, 0, 0, &dbugWin);
    CL_String fontString = "8.Courier";
    WinSetPresParam (dbugWin, PP_FONTNAMESIZE, fontString.Size()+1,
                     (void*) fontString.AsPtr());
#endif
}
#endif
