// File: ControllerWithAccel.c++
/************************************************************************/
/*                                                                      */
/* Author      : Ludovic Brenta                                         */
/* Date        : 28 Jan 1996                                            */
/* Compiler    : EMX 0.9a (GCC 2.6.3) under OS/2 3.0 (Warp)             */
/*                                                                      */
/************************************************************************/


// I'm going to do some OS/2-specific stuff here
#ifdef __OS2__
#define INCL_NOCOMMON
#define INCL_WIN
#include <os2.h>
#endif

#include "ControllerWithAccel.h"
#include "ui/timer.h"
#include "ui/cntroler.h"
#include "ui/applic.h"
#include "ui/menu.h"
#include "ui/composit.h"
#include "ui/event.h"
#include "ui/btngroup.h"
#include "ui/stred.h"

//////////////////////////////////////////////////////////////////////////
// Add and remove accelerators

inline bool UI_ControllerWithAccel::AddAccelerator(long accel,
   UI_VisualObject* target, UI_EventType eventType)
{
   UI_AcceleratorTarget *Target = new UI_AcceleratorTarget;
   Target->target = target;
   Target->eventType = eventType;
   return _accelTable.Add(accel, Target);
}

inline bool UI_ControllerWithAccel::RemoveAccelerator(long accel)
{
   UI_AcceleratorTarget *target = (UI_AcceleratorTarget *) _accelTable[accel];
   if(!target) return FALSE;
   else
   {
      _accelTable.Remove(accel);
      delete target;
      return TRUE;
   }
}

bool UI_ControllerWithAccel::AddAcceleratorTable(UI_AcceleratorTable table[],
   UI_Menu& menu)
{
   short i = 0;
   while(table[i].key)
   {
      UI_AcceleratorTarget *target = new UI_AcceleratorTarget;
      target->target = menu[table[i].targetID];
      target->eventType = table[i].eventType;
      if(!_accelTable.Add(table[i].key, target))
         return FALSE;
      i++;
   }
   return TRUE;
}


//////////////////////////////////////////////////////////////////////////
// The core method of the class

bool UI_ControllerWithAccel::TranslateNativeEvent(NativeEventStruct& msg,
   UI_Event& e)
{
   // Call the inherited method, then do our stuff on WM_CHAR messages that
   // are YACL events (i.e. intended for one of our windows)

   bool returnCode = UI_Controller::TranslateNativeEvent(msg, e);

   if(returnCode && msg.msg == WM_CHAR)
   {
      // Compute the "extended key code"
      long vKey = 0L;
      short kc = SHORT1FROMMP(msg.mp1);

      if(kc & KC_VIRTUALKEY)    vKey = SHORT2FROMMP(msg.mp2) | Key_Virtual;
      else                      vKey = SHORT1FROMMP(msg.mp2);
      if(kc & KC_SHIFT)        vKey |= Key_Shift;
      if(kc & KC_CTRL)          vKey |= Key_Ctrl;
      if(kc & KC_ALT)          vKey |= Key_Alt;

      // Look to see if it's an accelerator
      UI_AcceleratorTarget* target = (UI_AcceleratorTarget*) _accelTable[vKey];
      if(target && target->target->IsEnabled())
      {
         e._type = target->eventType;
         e._dest = e._origin = target->target;
         return TRUE;
      }
   }
   return returnCode;
}


